/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.SceneEnum;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.sub_erupt.LinkTree;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.naming.EruptOperateConfig;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/data/modify"})
public class EruptModifyController {
    private static final Logger log = LoggerFactory.getLogger(EruptModifyController.class);
    private final Gson gson = GsonFactory.getGson();
    private final EruptService eruptService;

    @PostMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="\u65b0\u589e", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel addEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data, JsonObject jsonObject, HttpServletRequest request) {
        EruptApiModel eruptApiModel;
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isAdd);
        LinkTree dependTree = eruptModel.getErupt().linkTree();
        if (StringUtils.isNotBlank((CharSequence)dependTree.field()) && dependTree.dependNode()) {
            String linkVal = request.getHeader("link");
            if (dependTree.dependNode()) {
                if (StringUtils.isBlank((CharSequence)linkVal)) {
                    return EruptApiModel.errorApi("\u8bf7\u9009\u62e9\u6811\u8282\u70b9");
                }
                if (null == jsonObject) {
                    jsonObject = new JsonObject();
                }
                String rm = ReflectUtil.findClassField(eruptModel.getClazz(), dependTree.field()).getType().getSimpleName();
                JsonObject sub = new JsonObject();
                sub.addProperty(EruptCoreService.getErupt(rm).getErupt().primaryKeyCol(), linkVal);
                jsonObject.add(dependTree.field(), (JsonElement)sub);
            }
        }
        if ((eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data)).getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        Object o = this.gson.fromJson(data.toString(), eruptModel.getClazz());
        EruptUtil.clearObjectDefaultValueByJson(o, data);
        Object obj = EruptUtil.dataTarget(eruptModel, o, eruptModel.getClazz().newInstance(), SceneEnum.ADD);
        if (null != jsonObject) {
            for (String key : jsonObject.keySet()) {
                Field field = ReflectUtil.findClassField(eruptModel.getClazz(), key);
                field.setAccessible(true);
                field.set(obj, this.gson.fromJson(jsonObject.get(key).toString(), field.getType()));
            }
        }
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeAdd(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).addData(eruptModel, obj);
        this.modifyLog(eruptModel, "ADD", data.toString());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterAdd(obj));
        return EruptApiModel.successApi();
    }

    @PutMapping(value={"/{erupt}"})
    @EruptRecordOperate(value="\u4fee\u6539", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel editEruptData(@PathVariable(value="erupt") String erupt, @RequestBody JsonObject data) throws IllegalAccessException {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isEdit);
        EruptApiModel eruptApiModel = EruptUtil.validateEruptValue(eruptModel, data);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
            return eruptApiModel;
        }
        this.eruptService.verifyIdPermissions(eruptModel, data.get(eruptModel.getErupt().primaryKeyCol()).getAsString());
        Object o = this.gson.fromJson(data.toString(), eruptModel.getClazz());
        EruptUtil.clearObjectDefaultValueByJson(o, data);
        Object obj = EruptUtil.dataTarget(eruptModel, o, DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).findDataById(eruptModel, ReflectUtil.findClassField(eruptModel.getClazz(), eruptModel.getErupt().primaryKeyCol()).get(o)), SceneEnum.EDIT);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeUpdate(obj));
        DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz()).editData(eruptModel, obj);
        this.modifyLog(eruptModel, "EDIT", data.toString());
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterUpdate(obj));
        return EruptApiModel.successApi();
    }

    @DeleteMapping(value={"/{erupt}/{id}"})
    @EruptRecordOperate(value="\u5220\u9664", dynamicConfig=EruptOperateConfig.class)
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel deleteEruptData(@PathVariable(value="erupt") String erupt, @PathVariable(value="id") String id) {
        EruptModel eruptModel = EruptCoreService.getErupt(erupt);
        Erupts.powerLegal(eruptModel, PowerObject::isDelete);
        this.eruptService.verifyIdPermissions(eruptModel, id);
        IEruptDataService dataService = DataProcessorManager.getEruptDataProcessor(eruptModel.getClazz());
        Object obj = dataService.findDataById(eruptModel, EruptUtil.toEruptId(eruptModel, id));
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.beforeDelete(obj));
        dataService.deleteData(eruptModel, obj);
        this.modifyLog(eruptModel, "DELETE", id);
        DataProxyInvoke.invoke(eruptModel, dataProxy -> dataProxy.afterDelete(obj));
        return EruptApiModel.successApi();
    }

    @Transactional
    @DeleteMapping(value={"/{erupt}"})
    @EruptRouter(skipAuthIndex=3, authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    @EruptRecordOperate(value="\u6279\u91cf\u5220\u9664", dynamicConfig=EruptOperateConfig.class)
    public EruptApiModel deleteEruptDataList(@PathVariable(value="erupt") String erupt, @RequestParam(value="ids") String[] ids) {
        String id;
        EruptApiModel eruptApiModel = EruptApiModel.successApi();
        String[] stringArray = ids;
        int n = stringArray.length;
        for (int i = 0; i < n && (eruptApiModel = this.deleteEruptData(erupt, id = stringArray[i])).getStatus() != EruptApiModel.Status.ERROR; ++i) {
        }
        return eruptApiModel;
    }

    private void modifyLog(EruptModel eruptModel, String placeholder, String content) {
        log.info("[" + eruptModel.getEruptName() + " -> " + placeholder + "]:" + content);
    }

    public EruptModifyController(EruptService eruptService) {
        this.eruptService = eruptService;
    }
}

