/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.sub_edit.AttachmentType;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/file"})
public class EruptFileController {
    private final EruptProp eruptProp;
    private static final String FS_SEP = "/";
    private static final String DOWNLOAD_PATH = "/download-attachment";

    @PostMapping(value={"/upload/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel upload(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="file") MultipartFile file) {
        String path;
        if (file.isEmpty() || StringUtils.isBlank((CharSequence)file.getOriginalFilename())) {
            return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Erupts.powerLegal(eruptModel, powerObject -> powerObject.isEdit() || powerObject.isAdd());
        Edit edit = eruptModel.getEruptFieldMap().get(fieldName).getEruptField().edit();
        if (this.eruptProp.isKeepUploadFileName()) {
            path = File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + file.getOriginalFilename().replaceAll("&|#|\\?|\\s", "").replace(edit.attachmentType().fileSeparator(), "");
        } else {
            String[] fileNameSplit = file.getOriginalFilename().split("\\.");
            path = File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + RandomStringUtils.randomAlphabetic((int)12) + "." + fileNameSplit[fileNameSplit.length - 1];
        }
        switch (edit.type()) {
            case ATTACHMENT: {
                AttachmentType attachmentType = edit.attachmentType();
                if (attachmentType.fileTypes().length > 0) {
                    String[] fileNameArr = file.getOriginalFilename().split("\\.");
                    String extensionName = fileNameArr[fileNameArr.length - 1];
                    if (Stream.of(attachmentType.fileTypes()).noneMatch(type -> extensionName.equalsIgnoreCase((String)type))) {
                        return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u5141\u8bb8\u4e3a\uff1a" + extensionName);
                    }
                }
                if (!"".equals(attachmentType.path())) {
                    path = attachmentType.path() + path;
                }
                if (attachmentType.size() > 0L && file.getSize() / 1024L > attachmentType.size()) {
                    return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + attachmentType.size() + "KB");
                }
                switch (edit.attachmentType().type()) {
                    case IMAGE: {
                        AttachmentType.ImageType imageType = edit.attachmentType().imageType();
                        BufferedImage bufferedImage = ImageIO.read(file.getInputStream());
                        if (bufferedImage == null) {
                            return EruptApiModel.errorApi("\u83b7\u53d6\u56fe\u7247\u6d41\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u4e3a\u56fe\u7247");
                        }
                        int width = bufferedImage.getWidth();
                        int height = bufferedImage.getHeight();
                        if (imageType.minWidth() > width || imageType.maxWidth() < width) {
                            return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u56fe\u7247\u5bbd\u5ea6\u4e0d\u5728[" + imageType.minWidth() + "," + imageType.maxWidth() + "]\u8303\u56f4\u5185");
                        }
                        if (imageType.minHeight() <= height && imageType.maxHeight() >= height) break;
                        return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u56fe\u7247\u9ad8\u5ea6\u4e0d\u5728[" + imageType.minHeight() + "," + imageType.maxHeight() + "]\u8303\u56f4\u5185");
                    }
                }
                break;
            }
            case HTML_EDITOR: {
                break;
            }
            default: {
                return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u975e\u6cd5\u7c7b\u578b!");
            }
        }
        try {
            boolean localSave = true;
            AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
            if (null != attachmentProxy) {
                path = attachmentProxy.upLoad(file.getInputStream(), path.replace("\\", FS_SEP));
                localSave = attachmentProxy.isLocalSave();
            }
            if (localSave) {
                File dest = new File(this.eruptProp.getUploadPath() + path);
                if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                    return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa");
                }
                file.transferTo(dest);
            }
            return EruptApiModel.successApi(path.replace("\\", FS_SEP));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EruptApiModel.errorApi("\u4e0a\u4f20\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    @PostMapping(value={"/uploads/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel uploads(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="file") MultipartFile[] files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (MultipartFile file : files) {
            EruptApiModel eruptApiModel = this.upload(eruptName, fieldName, file);
            paths.add(eruptApiModel.getMessage());
        }
        return EruptApiModel.successApi(String.join((CharSequence)",", paths));
    }

    @PostMapping(value={"/upload-html-editor/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyMethod=EruptRouter.VerifyMethod.PARAM, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> uploadHtmlEditorImage(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="upload") MultipartFile file) throws ClassNotFoundException {
        EruptApiModel eruptApiModel = this.upload(eruptName, fieldName, file);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.SUCCESS) {
            AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
            if (null != attachmentProxy) {
                map.put("url", attachmentProxy.fileDomain() + eruptApiModel.getData());
            } else {
                map.put("url", "/erupt-attachment" + eruptApiModel.getData());
            }
        } else {
            map.put("uploaded", false);
            throw new EruptWebApiRuntimeException(eruptApiModel.getMessage());
        }
        map.put("uploaded", true);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload-ueditor/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyMethod=EruptRouter.VerifyMethod.PARAM, verifyType=EruptRouter.VerifyType.ERUPT)
    public void uploadUEditorImage(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="file", required=false) MultipartFile file, HttpServletResponse response) throws IOException, ClassNotFoundException {
        if (null == file) {
            InputStream stream = EruptFileController.class.getClassLoader().getResourceAsStream("ueditor.json");
            try {
                String json = StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName(StandardCharsets.UTF_8.name()));
                if (null == callback) {
                    response.getOutputStream().write(json.getBytes(StandardCharsets.UTF_8));
                }
                response.getOutputStream().write((callback + "(" + json + ")").getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        } else {
            Map<String, Object> map;
            Boolean status = (Boolean)(map = this.uploadHtmlEditorImage(eruptName, fieldName, file)).get("uploaded");
            map.put("state", status != false ? "SUCCESS" : "ERROR");
            response.getOutputStream().write(new Gson().toJson(map).getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download-attachment/**"}, produces={"application/octet-stream"})
    public void downloadAttachment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File file;
        String path = request.getServletPath().replace("/erupt-api/file/download-attachment", "");
        if (!path.startsWith(FS_SEP)) {
            path = FS_SEP + path;
        }
        if (!(file = new File(this.eruptProp.getUploadPath() + path)).exists()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            response.sendError(HttpStatus.NOT_FOUND.value());
            return;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            response.getOutputStream().write(StreamUtils.copyToByteArray((InputStream)inputStream));
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    public EruptFileController(EruptProp eruptProp) {
        this.eruptProp = eruptProp;
    }
}

