/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.view.EruptBuildModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/build"})
public class EruptBuildController {
    @GetMapping(value={"/{erupt}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptBuildModel getEruptBuild(@PathVariable(value="erupt") String eruptName) {
        EruptModel eruptView = EruptCoreService.getEruptView(eruptName);
        EruptBuildModel eruptBuildModel = new EruptBuildModel();
        eruptBuildModel.setPower(PowerInvoke.getPowerObject(eruptView));
        eruptBuildModel.setEruptModel(eruptView);
        eruptView.getEruptFieldModels().forEach(fieldModel -> {
            switch (fieldModel.getEruptField().edit().type()) {
                case TAB_TREE: {
                    eruptBuildModel.setTabErupts(Optional.ofNullable(eruptBuildModel.getTabErupts()).orElse(new LinkedHashMap()));
                    EruptBuildModel m1 = new EruptBuildModel();
                    m1.setEruptModel(EruptCoreService.getEruptView(fieldModel.getFieldReturnName()));
                    eruptBuildModel.getTabErupts().put(fieldModel.getFieldName(), m1);
                    break;
                }
                case TAB_TABLE_ADD: 
                case TAB_TABLE_REFER: {
                    eruptBuildModel.setTabErupts(Optional.ofNullable(eruptBuildModel.getTabErupts()).orElse(new LinkedHashMap()));
                    eruptBuildModel.getTabErupts().put(fieldModel.getFieldName(), this.getEruptBuild(fieldModel.getFieldReturnName()));
                    break;
                }
                case COMBINE: {
                    eruptBuildModel.setCombineErupts(Optional.ofNullable(eruptBuildModel.getCombineErupts()).orElse(new LinkedHashMap()));
                    eruptBuildModel.getCombineErupts().put(fieldModel.getFieldName(), EruptCoreService.getEruptView(fieldModel.getFieldReturnName()));
                }
            }
        });
        Arrays.stream(eruptBuildModel.getEruptModel().getErupt().rowOperation()).filter(operation -> operation.eruptClass() != Void.TYPE && operation.type() == RowOperation.Type.ERUPT).forEach(operation -> {
            eruptBuildModel.setOperationErupts(Optional.ofNullable(eruptBuildModel.getOperationErupts()).orElse(new LinkedHashMap()));
            eruptBuildModel.getOperationErupts().put(operation.code(), EruptCoreService.getEruptView(operation.eruptClass().getSimpleName()));
        });
        return eruptBuildModel;
    }

    @GetMapping(value={"/{erupt}/{field}"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptBuildModel getEruptBuildByField(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field) {
        return this.getEruptBuild(EruptCoreService.getEruptView(eruptName).getEruptFieldMap().get(field).getFieldReturnName());
    }
}

