/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import xyz.erupt.core.prop.EruptAppProp;
import xyz.erupt.core.util.EruptInformation;
import xyz.erupt.core.util.MD5Util;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptApi {
    private final EruptAppProp eruptAppProp;

    @GetMapping(value={"/version"})
    public String version() {
        return EruptInformation.getEruptVersion();
    }

    @GetMapping(value={"/erupt-app"})
    public EruptAppProp eruptApp() {
        this.eruptAppProp.setHash(this.hashCode());
        this.eruptAppProp.setVersion(EruptInformation.getEruptVersion());
        return this.eruptAppProp;
    }

    @GetMapping(value={"/erupt-machine-code"})
    public String eruptMachineCode() {
        HardwareAbstractionLayer hal = new SystemInfo().getHardware();
        return MD5Util.digest(hal.getProcessor().getProcessorIdentifier().getProcessorID() + hal.getComputerSystem().getSerialNumber() + hal.getComputerSystem().getHardwareUUID());
    }

    public EruptApi(EruptAppProp eruptAppProp) {
        this.eruptAppProp = eruptAppProp;
    }
}

