/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.config;

import com.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class HikariCpConfig {
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final int DEFAULT_POOL_SIZE = 10;
    private String username;
    private String password;
    private String driverClassName;
    private String jdbcUrl;
    private String poolName;
    private String catalog;
    private Long connectionTimeout;
    private Long validationTimeout;
    private Long idleTimeout;
    private Long leakDetectionThreshold;
    private Long maxLifetime;
    private Integer maxPoolSize;
    private Integer minIdle;
    private Long initializationFailTimeout;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String schema;
    private String transactionIsolationName;
    private Boolean isAutoCommit;
    private Boolean isReadOnly;
    private Boolean isIsolateInternalQueries;
    private Boolean isRegisterMbeans;
    private Boolean isAllowPoolSuspension;
    private Properties dataSourceProperties;
    private Properties healthCheckProperties;

    public HikariConfig toHikariConfig() {
        Properties tempHealthCheckProperties;
        Properties tempDataSourceProperties;
        Boolean tempAllowPoolSuspension;
        Boolean tempRegisterMbeans;
        Boolean tempIsolateInternalQueries;
        Boolean tempReadOnly;
        Boolean tempAutoCommit;
        String tempTransactionIsolationName;
        String tempDataSourceJndiName;
        String tempDataSourceClassName;
        String tempConnectionTestQuery;
        String tempConnectionInitSql;
        Long tempInitializationFailTimeout;
        Integer tempMinIdle;
        Integer tempMaxPoolSize;
        Long tempMaxLifetime;
        Long tempLeakDetectionThreshold;
        Long tempIdleTimeout;
        Long tempValidationTimeout;
        Long tempConnectionTimeout;
        String tempCatalog;
        String tempSchema;
        HikariCpConfig g = this;
        HikariConfig config = new HikariConfig();
        String string = tempSchema = this.schema == null ? g.getSchema() : this.schema;
        if (tempSchema != null) {
            Field schemaField = HikariConfig.class.getDeclaredField("schema");
            schemaField.setAccessible(true);
            schemaField.set(config, tempSchema);
        }
        String string2 = tempCatalog = this.catalog == null ? g.getCatalog() : this.catalog;
        if (tempCatalog != null) {
            config.setCatalog(tempCatalog);
        }
        Long l = tempConnectionTimeout = this.connectionTimeout == null ? g.getConnectionTimeout() : this.connectionTimeout;
        if (tempConnectionTimeout != null && !tempConnectionTimeout.equals(CONNECTION_TIMEOUT)) {
            config.setConnectionTimeout(tempConnectionTimeout.longValue());
        }
        Long l2 = tempValidationTimeout = this.validationTimeout == null ? g.getValidationTimeout() : this.validationTimeout;
        if (tempValidationTimeout != null && !tempValidationTimeout.equals(VALIDATION_TIMEOUT)) {
            config.setValidationTimeout(tempValidationTimeout.longValue());
        }
        Long l3 = tempIdleTimeout = this.idleTimeout == null ? g.getIdleTimeout() : this.idleTimeout;
        if (tempIdleTimeout != null && !tempIdleTimeout.equals(IDLE_TIMEOUT)) {
            config.setIdleTimeout(tempIdleTimeout.longValue());
        }
        Long l4 = tempLeakDetectionThreshold = this.leakDetectionThreshold == null ? g.getLeakDetectionThreshold() : this.leakDetectionThreshold;
        if (tempLeakDetectionThreshold != null) {
            config.setLeakDetectionThreshold(tempLeakDetectionThreshold.longValue());
        }
        Long l5 = tempMaxLifetime = this.maxLifetime == null ? g.getMaxLifetime() : this.maxLifetime;
        if (tempMaxLifetime != null && !tempMaxLifetime.equals(MAX_LIFETIME)) {
            config.setMaxLifetime(tempMaxLifetime.longValue());
        }
        Integer n = tempMaxPoolSize = this.maxPoolSize == null ? g.getMaxPoolSize() : this.maxPoolSize;
        if (tempMaxPoolSize != null && !tempMaxPoolSize.equals(-1)) {
            config.setMaximumPoolSize(tempMaxPoolSize.intValue());
        }
        Integer n2 = tempMinIdle = this.minIdle == null ? g.getMinIdle() : this.getMinIdle();
        if (tempMinIdle != null && !tempMinIdle.equals(-1)) {
            config.setMinimumIdle(tempMinIdle.intValue());
        }
        Long l6 = tempInitializationFailTimeout = this.initializationFailTimeout == null ? g.getInitializationFailTimeout() : this.initializationFailTimeout;
        if (tempInitializationFailTimeout != null && !tempInitializationFailTimeout.equals(1L)) {
            config.setInitializationFailTimeout(tempInitializationFailTimeout.longValue());
        }
        String string3 = tempConnectionInitSql = this.connectionInitSql == null ? g.getConnectionInitSql() : this.connectionInitSql;
        if (tempConnectionInitSql != null) {
            config.setConnectionInitSql(tempConnectionInitSql);
        }
        String string4 = tempConnectionTestQuery = this.connectionTestQuery == null ? g.getConnectionTestQuery() : this.connectionTestQuery;
        if (tempConnectionTestQuery != null) {
            config.setConnectionTestQuery(tempConnectionTestQuery);
        }
        String string5 = tempDataSourceClassName = this.dataSourceClassName == null ? g.getDataSourceClassName() : this.dataSourceClassName;
        if (tempDataSourceClassName != null) {
            config.setDataSourceClassName(tempDataSourceClassName);
        }
        String string6 = tempDataSourceJndiName = this.dataSourceJndiName == null ? g.getDataSourceJndiName() : this.dataSourceJndiName;
        if (tempDataSourceJndiName != null) {
            config.setDataSourceJNDI(tempDataSourceJndiName);
        }
        String string7 = tempTransactionIsolationName = this.transactionIsolationName == null ? g.getTransactionIsolationName() : this.transactionIsolationName;
        if (tempTransactionIsolationName != null) {
            config.setTransactionIsolation(tempTransactionIsolationName);
        }
        Boolean bl = tempAutoCommit = this.isAutoCommit == null ? g.getIsAutoCommit() : this.isAutoCommit;
        if (tempAutoCommit != null && tempAutoCommit.equals(Boolean.FALSE)) {
            config.setAutoCommit(false);
        }
        Boolean bl2 = tempReadOnly = this.isReadOnly == null ? g.getIsReadOnly() : this.isReadOnly;
        if (tempReadOnly != null) {
            config.setReadOnly(tempReadOnly.booleanValue());
        }
        Boolean bl3 = tempIsolateInternalQueries = this.isIsolateInternalQueries == null ? g.getIsIsolateInternalQueries() : this.isIsolateInternalQueries;
        if (tempIsolateInternalQueries != null) {
            config.setIsolateInternalQueries(tempIsolateInternalQueries.booleanValue());
        }
        Boolean bl4 = tempRegisterMbeans = this.isRegisterMbeans == null ? g.getIsRegisterMbeans() : this.isRegisterMbeans;
        if (tempRegisterMbeans != null) {
            config.setRegisterMbeans(tempRegisterMbeans.booleanValue());
        }
        Boolean bl5 = tempAllowPoolSuspension = this.isAllowPoolSuspension == null ? g.getIsAllowPoolSuspension() : this.isAllowPoolSuspension;
        if (tempAllowPoolSuspension != null) {
            config.setAllowPoolSuspension(tempAllowPoolSuspension.booleanValue());
        }
        Properties properties = tempDataSourceProperties = this.dataSourceProperties == null ? g.getDataSourceProperties() : this.dataSourceProperties;
        if (tempDataSourceProperties != null) {
            config.setDataSourceProperties(tempDataSourceProperties);
        }
        Properties properties2 = tempHealthCheckProperties = this.healthCheckProperties == null ? g.getHealthCheckProperties() : this.healthCheckProperties;
        if (tempHealthCheckProperties != null) {
            config.setHealthCheckProperties(tempHealthCheckProperties);
        }
        return config;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getValidationTimeout() {
        return this.validationTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public Long getMaxLifetime() {
        return this.maxLifetime;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Long getInitializationFailTimeout() {
        return this.initializationFailTimeout;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTransactionIsolationName() {
        return this.transactionIsolationName;
    }

    public Boolean getIsAutoCommit() {
        return this.isAutoCommit;
    }

    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public Boolean getIsIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public Boolean getIsRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public Boolean getIsAllowPoolSuspension() {
        return this.isAllowPoolSuspension;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public Properties getHealthCheckProperties() {
        return this.healthCheckProperties;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setValidationTimeout(Long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setLeakDetectionThreshold(Long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    public void setMaxLifetime(Long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setInitializationFailTimeout(Long initializationFailTimeout) {
        this.initializationFailTimeout = initializationFailTimeout;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTransactionIsolationName(String transactionIsolationName) {
        this.transactionIsolationName = transactionIsolationName;
    }

    public void setIsAutoCommit(Boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setIsIsolateInternalQueries(Boolean isIsolateInternalQueries) {
        this.isIsolateInternalQueries = isIsolateInternalQueries;
    }

    public void setIsRegisterMbeans(Boolean isRegisterMbeans) {
        this.isRegisterMbeans = isRegisterMbeans;
    }

    public void setIsAllowPoolSuspension(Boolean isAllowPoolSuspension) {
        this.isAllowPoolSuspension = isAllowPoolSuspension;
    }

    public void setDataSourceProperties(Properties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    public void setHealthCheckProperties(Properties healthCheckProperties) {
        this.healthCheckProperties = healthCheckProperties;
    }
}

