/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Tok;

public class SqNOPImpl<P extends Pointer<?, ?, P>> {
    final List<GR<P, ? extends Tok<P>>> expressions;

    @SafeVarargs
    public SqNOPImpl(GR<P, ? extends Tok<P>> ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        for (int i = 0; i < expressions.length; ++i) {
            if (expressions[i] != null) continue;
            throw new IllegalArgumentException("expression[" + i + "]==null");
        }
        this.expressions = Arrays.asList(expressions);
    }

    public Optional<List<? extends Tok<P>>> match(P ptr) {
        if (ptr == null) {
            throw new IllegalArgumentException("ptr == null");
        }
        ArrayList<Tok> matched = new ArrayList<Tok>();
        for (GR<P, Tok<P>> expression : this.expressions) {
            if (ptr.eof()) break;
            GR<P, Tok<P>> exp = expression;
            if (exp == null) {
                throw new IllegalStateException("bug!!");
            }
            Optional tok = (Optional)exp.apply((Tok<P>)ptr);
            if (tok == null) {
                throw new IllegalStateException("bug!!");
            }
            if (!tok.isPresent()) break;
            if (tok.get() == null) {
                throw new IllegalStateException("bug!!");
            }
            Object next = ((Tok)tok.get()).end();
            if (next == null) {
                throw new IllegalStateException("bug!!");
            }
            if (ptr.compareTo(next) >= 0) {
                throw new IllegalStateException("bug!!");
            }
            matched.add((Tok)tok.get());
            ptr = next;
        }
        if (matched.size() == this.expressions.size()) {
            return Optional.of(matched);
        }
        return Optional.empty();
    }
}

