/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.Optional;
import xyz.cofe.text.tparse.Pointer;

public class CharPointer
implements Pointer<Character, Integer, CharPointer> {
    private final String source;
    private final int offset;

    public CharPointer(String source, int offset) {
        this.source = source;
        this.offset = offset;
    }

    public CharPointer(String source) {
        this.source = source;
        this.offset = 0;
    }

    public String source() {
        return this.source;
    }

    @Override
    public boolean eof() {
        if (this.source == null) {
            return true;
        }
        if (this.offset < 0) {
            return true;
        }
        return this.offset >= this.source.length();
    }

    @Override
    public Integer position() {
        return this.offset;
    }

    @Override
    public CharPointer move(Integer offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset == null");
        }
        return new CharPointer(this.source, this.offset + offset);
    }

    @Override
    public Optional<Character> lookup(Integer offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset == null");
        }
        if (this.eof()) {
            return Optional.empty();
        }
        int t = this.position() + offset;
        if (t < 0) {
            return Optional.empty();
        }
        if (t >= this.source.length()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(this.source.charAt(t)));
    }

    @Override
    public int compareTo(CharPointer o) {
        if (o == null) {
            return 0;
        }
        if (this.source != o.source && !o.source.equals(this.source)) {
            return 0;
        }
        int x = o.position();
        return Integer.compare(this.offset, x);
    }

    public String toString() {
        return "CharPointer " + this.position();
    }
}

