/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.font.ButtonFontTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabFontTransmitter;
import bibliothek.gui.dock.common.intern.font.TitleFontTransmitter;
import bibliothek.gui.dock.common.theme.color.CColorBridge;
import bibliothek.gui.dock.common.theme.color.CColorBridgeExtension;
import bibliothek.gui.dock.common.theme.color.ExtendedColorBridge;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CDockTheme<D extends DockTheme>
implements DockTheme {
    private D theme;
    private DockTheme delegate;
    private Map<Path, ColorBridgeFactory> colorBridgeFactories = new HashMap<Path, ColorBridgeFactory>();
    private Map<Path, FontBridgeFactory> fontBridgeFactories = new HashMap<Path, FontBridgeFactory>();
    private List<Controller> controllers = new ArrayList<Controller>();
    private DockThemeExtension[] extensions;

    public CDockTheme(D delegate) {
        this(delegate, (DockTheme)delegate);
    }

    public CDockTheme(D theme, DockTheme delegate) {
        if (theme == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.theme = theme;
        this.delegate = delegate;
    }

    protected void initDefaultFontBridges(final CControl control) {
        this.putFontBridgeFactory(TitleFont.KIND_TITLE_FONT, new FontBridgeFactory(){

            @Override
            public FontBridge create(FontManager manager) {
                TitleFontTransmitter transmitter = new TitleFontTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putFontBridgeFactory(TitleFont.KIND_FLAP_BUTTON_FONT, new FontBridgeFactory(){

            @Override
            public FontBridge create(FontManager manager) {
                ButtonFontTransmitter transmitter = new ButtonFontTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putFontBridgeFactory(TabFont.KIND_TAB_FONT, new FontBridgeFactory(){

            @Override
            public FontBridge create(FontManager manager) {
                TabFontTransmitter transmitter = new TabFontTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
    }

    public D intern() {
        return this.theme;
    }

    public Combiner getCombiner(DockStation station) {
        return this.delegate.getCombiner(station);
    }

    public DisplayerFactory getDisplayFactory(DockStation station) {
        return this.delegate.getDisplayFactory(station);
    }

    public DockableMovingImageFactory getMovingImageFactory(DockController controller) {
        return this.delegate.getMovingImageFactory(controller);
    }

    public StationPaint getPaint(DockStation station) {
        return this.delegate.getPaint(station);
    }

    public DockTitleFactory getTitleFactory(DockController controller) {
        return this.delegate.getTitleFactory(controller);
    }

    public DockableSelection getDockableSelection(DockController controller) {
        return this.delegate.getDockableSelection(controller);
    }

    public void putColorBridgeFactory(Path kind, ColorBridgeFactory factory) {
        this.colorBridgeFactories.put(kind, factory);
        for (Controller setting : this.controllers) {
            ColorBridge newBridge;
            ColorManager colors = setting.controller.getColors();
            ColorBridge oldBridge = setting.colors.remove(kind);
            ColorBridge colorBridge = newBridge = factory == null ? null : factory.create(colors);
            if (newBridge == null) {
                setting.colors.remove(kind);
                if (oldBridge == null) continue;
                colors.unpublish(Priority.DEFAULT, kind);
                continue;
            }
            setting.colors.put(kind, newBridge);
            colors.publish(Priority.DEFAULT, kind, (UIBridge)newBridge);
        }
    }

    public void putFontBridgeFactory(Path kind, FontBridgeFactory factory) {
        this.fontBridgeFactories.put(kind, factory);
        for (Controller setting : this.controllers) {
            FontBridge newBridge;
            FontManager fonts = setting.controller.getFonts();
            FontBridge oldBridge = setting.fonts.remove(kind);
            FontBridge fontBridge = newBridge = factory == null ? null : factory.create(fonts);
            if (newBridge == null) {
                setting.fonts.remove(kind);
                if (oldBridge == null) continue;
                fonts.unpublish(Priority.DEFAULT, kind);
                continue;
            }
            setting.fonts.put(kind, newBridge);
            fonts.publish(Priority.DEFAULT, kind, (UIBridge)newBridge);
        }
    }

    public void install(DockController controller, DockThemeExtension[] extensions) {
        if (this.extensions != null) {
            throw new IllegalStateException("theme is already in use");
        }
        this.extensions = extensions;
        for (DockThemeExtension extension : extensions) {
            extension.install(controller, (DockTheme)this);
        }
        this.delegate.install(controller, extensions);
        this.install(controller);
        for (DockThemeExtension extension : extensions) {
            extension.installed(controller, (DockTheme)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(DockController controller) {
        Controller settings = new Controller();
        settings.controller = controller;
        ColorManager colors = controller.getColors();
        CControl control = (CControl)controller.getProperties().get(CControl.CCONTROL);
        try {
            colors.lockUpdate();
            ExtensionName name = new ExtensionName(CColorBridgeExtension.EXTENSION_NAME, CColorBridgeExtension.class, "theme", (Object)this);
            List extensions = controller.getExtensions().load(name);
            for (Map.Entry<Path, ColorBridgeFactory> entry : this.colorBridgeFactories.entrySet()) {
                ColorBridge bridge = entry.getValue().create(colors);
                Path key = entry.getKey();
                ArrayList<CColorBridgeExtension> filtered = new ArrayList<CColorBridgeExtension>();
                for (CColorBridgeExtension extension : extensions) {
                    if (!key.equals((Object)extension.getKey())) continue;
                    filtered.add(extension);
                }
                if (!filtered.isEmpty()) {
                    CColorBridge[] extending = new CColorBridge[filtered.size()];
                    for (int i = 0; i < extending.length; ++i) {
                        extending[i] = ((CColorBridgeExtension)filtered.get(i)).create(control, colors);
                    }
                    bridge = new ExtendedColorBridge(bridge, extending);
                }
                colors.publish(Priority.DEFAULT, entry.getKey(), (UIBridge)bridge);
                settings.colors.put(entry.getKey(), bridge);
            }
        }
        finally {
            colors.unlockUpdate();
        }
        FontManager fonts = controller.getFonts();
        try {
            fonts.lockUpdate();
            for (Map.Entry<Path, FontBridgeFactory> entry : this.fontBridgeFactories.entrySet()) {
                FontBridge bridge = entry.getValue().create(fonts);
                fonts.publish(Priority.DEFAULT, entry.getKey(), (UIBridge)bridge);
                settings.fonts.put(entry.getKey(), bridge);
            }
        }
        finally {
            fonts.unlockUpdate();
        }
        this.controllers.add(settings);
    }

    public void uninstall(DockController controller) {
        this.delegate.uninstall(controller);
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller settings = this.controllers.get(i);
            if (settings.controller != controller) continue;
            this.controllers.remove(i--);
            --n;
            ColorManager colors = controller.getColors();
            for (ColorBridge bridge : settings.colors.values()) {
                colors.unpublish(Priority.DEFAULT, (UIBridge)bridge);
            }
            FontManager fonts = controller.getFonts();
            for (FontBridge bridge : settings.fonts.values()) {
                fonts.unpublish(Priority.DEFAULT, (UIBridge)bridge);
            }
        }
        for (DockThemeExtension extension : this.extensions) {
            extension.uninstall(controller, (DockTheme)this);
        }
        this.extensions = null;
    }

    private class Controller {
        public DockController controller;
        public Map<Path, ColorBridge> colors = new HashMap<Path, ColorBridge>();
        public Map<Path, FontBridge> fonts = new HashMap<Path, FontBridge>();

        private Controller() {
        }
    }
}

