/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.core.CommonDockAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CloseActionSource
extends AbstractDockActionSource {
    private CDockable dockable;
    private CControlAccess control;
    private DockAction action;

    public CloseActionSource(CDockable dockable) {
        this.dockable = dockable;
        dockable.addCDockablePropertyListener(new CDockableAdapter(){

            @Override
            public void actionChanged(CDockable dockable, String key, CAction oldAction, CAction newAction) {
                CloseActionSource.this.update();
            }

            @Override
            public void closeableChanged(CDockable dockable) {
                CloseActionSource.this.update();
            }
        });
    }

    public void setControl(CControlAccess control) {
        this.control = control;
        this.update();
    }

    protected void update() {
        CommonDockAction next = null;
        if (this.control != null && this.dockable.isCloseable()) {
            CAction cnext = this.dockable.getAction("cdockable.close");
            next = cnext != null ? cnext.intern() : this.control.createCloseAction(this.dockable);
        }
        if (next != this.action) {
            if (this.action != null) {
                this.action = null;
                this.fireRemoved(0, 0);
            }
            if (next != null) {
                this.action = next;
                this.fireAdded(0, 0);
            }
        }
    }

    public DockAction getDockAction(int index) {
        if (index == 0 && this.action != null) {
            return this.action;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int getDockActionCount() {
        if (this.action == null) {
            return 0;
        }
        return 1;
    }

    public LocationHint getLocationHint() {
        return new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL);
    }

    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private DockAction action;
            {
                this.action = CloseActionSource.this.action;
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public DockAction next() {
                if (this.action == null) {
                    throw new NoSuchElementException();
                }
                DockAction result = this.action;
                this.action = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

