/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class RSSReader {
    public static void main(String[] args) {
        RSSReader rssreader = new RSSReader();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            String url = args[0];
            InputStreamReader stream = new InputStreamReader(new URL(url).openStream());
            parser.setInput((Reader)stream);
            XmlSerializer writer = factory.newSerializer();
            writer.setOutput((Writer)new OutputStreamWriter(System.out));
            rssreader.convertRSSToHtml(parser, writer);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void convertRSSToHtml(XmlPullParser parser, XmlSerializer writer) throws IOException, XmlPullParserException {
        if (parser.nextTag() == 2 && parser.getName().equals("rss")) {
            writer.startTag(null, "html");
            if (parser.nextTag() == 2 && parser.getName().equals("channel")) {
                this.convertChannelToHtml(parser, writer);
                parser.require(3, null, "channel");
            } else {
                new RuntimeException("expectd channel start tag not " + parser.getPositionDescription());
            }
        } else {
            throw new RuntimeException("expectd an RSS document at" + parser.getPositionDescription());
        }
        parser.nextTag();
        parser.require(3, null, "rss");
        writer.endTag(null, "html");
        writer.flush();
    }

    public void convertChannelToHtml(XmlPullParser parser, XmlSerializer writer) throws IOException, XmlPullParserException {
        boolean seenBody = false;
        while (parser.nextTag() != 3) {
            if (parser.getName().equals("title") && !seenBody) {
                writer.startTag(null, "head");
                writer.startTag(null, "title").text(parser.nextText()).endTag(null, "title");
                writer.endTag(null, "head");
                continue;
            }
            if (parser.getName().equals("item")) {
                if (!seenBody) {
                    writer.startTag(null, "body");
                    seenBody = true;
                }
                this.convertItemToHtml(parser, writer);
                continue;
            }
            int level = 1;
            while (level > 0) {
                switch (parser.next()) {
                    case 2: {
                        ++level;
                        break;
                    }
                    case 3: {
                        --level;
                    }
                }
            }
        }
        if (seenBody) {
            writer.endTag(null, "body");
        }
    }

    public void convertItemToHtml(XmlPullParser parser, XmlSerializer writer) throws IOException, XmlPullParserException {
        writer.startTag(null, "p");
        String title = null;
        String link = null;
        String description = null;
        while (parser.nextTag() != 3) {
            if (parser.getName().equals("title")) {
                title = parser.nextText();
                continue;
            }
            if (parser.getName().equals("link")) {
                link = parser.nextText();
                continue;
            }
            if (!parser.getName().equals("description")) continue;
            description = parser.nextText();
        }
        writer.startTag(null, "a");
        writer.attribute(null, "href", link);
        if (title != null) {
            writer.text(title);
        } else {
            writer.text(link);
        }
        writer.endTag(null, "a");
        writer.startTag(null, "br").endTag(null, "br");
        if (description != null) {
            writer.text(description);
        }
        writer.endTag(null, "p");
    }
}

