/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class MyXmlWriteApp {
    private static final String NAMESPACE = "http://www.megginson.com/ns/exp/poetry";

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        XmlSerializer serializer = factory.newSerializer();
        System.out.println("serializer implementation class is " + serializer.getClass());
        boolean addNewLine = false;
        int argPos = 0;
        while (argPos < args.length) {
            String arg = args[argPos];
            if ("-n".equals(arg)) {
                addNewLine = true;
            } else if ("-i".equals(arg)) {
                String s = args[++argPos];
                int indentSize = Integer.parseInt(s);
                StringBuffer buf = new StringBuffer(indentSize);
                int i = 0;
                while (i < indentSize) {
                    buf.append(' ');
                    ++i;
                }
                String indent = buf.toString();
                serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)indent);
            }
            ++argPos;
        }
        serializer.setOutput((Writer)new PrintWriter(System.out));
        serializer.startDocument(null, null);
        serializer.ignorableWhitespace("\n\n");
        serializer.setPrefix("", NAMESPACE);
        serializer.startTag(NAMESPACE, "poem");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "title");
        serializer.text("Roses are Red");
        serializer.endTag(NAMESPACE, "title");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "l").text("Roses are red,").endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "l").text("Violets are blue;").endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
        MyXmlWriteApp.writeLine(serializer, "Sugar is sweet,", addNewLine);
        MyXmlWriteApp.writeLine(serializer, "And I love you.,", addNewLine);
        serializer.endTag(NAMESPACE, "poem");
        serializer.endDocument();
    }

    private static void writeLine(XmlSerializer serializer, String line, boolean addNewLine) throws IOException {
        serializer.startTag(NAMESPACE, "l");
        serializer.text(line);
        serializer.endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
    }
}

