/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MyXmlPullApp {
    public static final String SAMPLE_XML = "<?xml version=\"1.0\"?>\n\n<poem xmlns=\"http://www.megginson.com/ns/exp/poetry\">\n<title>Roses are Red</title>\n<l>Roses are red,</l>\n<l>Violets are blue;</l>\n<l>Sugar is sweet,</l>\n<l>And I love you.</l>\n</poem>";
    int[] holderForStartAndLength = new int[2];

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser xpp = factory.newPullParser();
        System.out.println("parser implementation class is " + xpp.getClass());
        MyXmlPullApp app = new MyXmlPullApp();
        if (args.length == 0) {
            System.out.println("Parsing simple sample XML");
            xpp.setInput((Reader)new StringReader(SAMPLE_XML));
            app.processDocument(xpp);
        } else {
            int i = 0;
            while (i < args.length) {
                System.out.println("Parsing file: " + args[i]);
                xpp.setInput((Reader)new FileReader(args[i]));
                app.processDocument(xpp);
                ++i;
            }
        }
    }

    public void processDocument(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                System.out.println("Start document");
                continue;
            }
            if (eventType == 1) {
                System.out.println("End document");
                continue;
            }
            if (eventType == 2) {
                this.processStartElement(xpp);
                continue;
            }
            if (eventType == 3) {
                this.processEndElement(xpp);
                continue;
            }
            if (eventType != 4) continue;
            this.processText(xpp);
        } while ((eventType = xpp.next()) != 1);
    }

    public void processStartElement(XmlPullParser xpp) {
        String name = xpp.getName();
        String uri = xpp.getNamespace();
        if ("".equals(uri)) {
            System.out.println("Start element: " + name);
        } else {
            System.out.println("Start element: {" + uri + "}" + name);
        }
    }

    public void processEndElement(XmlPullParser xpp) {
        String name = xpp.getName();
        String uri = xpp.getNamespace();
        if ("".equals(uri)) {
            System.out.println("End element: " + name);
        } else {
            System.out.println("End element:   {" + uri + "}" + name);
        }
    }

    public void processText(XmlPullParser xpp) throws XmlPullParserException {
        char[] ch = xpp.getTextCharacters(this.holderForStartAndLength);
        int start = this.holderForStartAndLength[0];
        int length = this.holderForStartAndLength[1];
        System.out.print("Characters:    \"");
        int i = start;
        while (i < start + length) {
            switch (ch[i]) {
                case '\\': {
                    System.out.print("\\\\");
                    break;
                }
                case '\"': {
                    System.out.print("\\\"");
                    break;
                }
                case '\n': {
                    System.out.print("\\n");
                    break;
                }
                case '\r': {
                    System.out.print("\\r");
                    break;
                }
                case '\t': {
                    System.out.print("\\t");
                    break;
                }
                default: {
                    System.out.print(ch[i]);
                }
            }
            ++i;
        }
        System.out.print("\"\n");
    }
}

