/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ChannelPullHandler {
    private List items = new ArrayList();
    private XmlPullParser xmlPullParser = null;
    private Map channel = null;
    private String[] channelIdentifiers = new String[]{"channel", "rdf:description", "rss:channel"};
    private String[] itemIdentifiers = new String[]{"item", "rss:item"};
    private String[][] channelSynonymes = new String[][]{{"title", "rss:title"}, {"url", "link", "dc:identifier", "rss:link"}, {"date", "dc:date", "pubDate"}, {"description", "content:encoded", "rss:description"}, {"date", "dc:date", "lastBuildDate"}};
    private String[][] itemSynonymes = new String[][]{{"title", "rss:title"}, {"url", "link", "dc:identifier", "rss:link"}, {"date", "dc:date", "pubDate"}, {"description", "content:encoded", "rss:description"}};

    public ChannelPullHandler() throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        this.xmlPullParser = factory.newPullParser();
    }

    private List parseFirst(int type) throws IOException, XmlPullParserException {
        int level = 0;
        String lname = null;
        String value = null;
        ArrayList<KeyValueAttributes> values = new ArrayList<KeyValueAttributes>();
        HashMap<String, String> attributes = null;
        do {
            if (type == 1) {
                return values;
            }
            if (type == 4) {
                value = this.xmlPullParser.getText();
                continue;
            }
            if (type == 3) {
                if (--level < 0) {
                    return values;
                }
                if (!lname.equals(this.xmlPullParser.getName())) continue;
                values.add(new KeyValueAttributes(lname, value, attributes));
                attributes = null;
                continue;
            }
            if (type != 2) continue;
            if (level == 0) {
                ++level;
                lname = this.xmlPullParser.getName();
                if (this.xmlPullParser.getAttributeCount() > 0) {
                    attributes = new HashMap<String, String>();
                    int i = 0;
                    while (i < this.xmlPullParser.getAttributeCount()) {
                        attributes.put(this.xmlPullParser.getAttributeName(i), this.xmlPullParser.getAttributeValue(i));
                        ++i;
                    }
                }
            } else {
                values.add(new KeyValueAttributes(lname, this.parseFirst(type), null));
                --level;
                lname = this.xmlPullParser.getName();
            }
            value = null;
        } while ((type = this.xmlPullParser.next()) != 1);
        return values;
    }

    private void parseSecond(List values) {
        int i = 0;
        while (i < values.size()) {
            KeyValueAttributes pair = (KeyValueAttributes)values.get(i);
            if (pair.value instanceof List) {
                boolean foundSomething = false;
                int j = 0;
                while (j < this.channelIdentifiers.length) {
                    if (pair.key.equals(this.channelIdentifiers[j])) {
                        this.workOnChannel((List)pair.value);
                        foundSomething = true;
                        break;
                    }
                    ++j;
                }
                if (!foundSomething) {
                    j = 0;
                    while (j < this.itemIdentifiers.length) {
                        if (pair.key.equals(this.itemIdentifiers[j])) {
                            this.workOnItem((List)pair.value);
                            foundSomething = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundSomething) {
                        this.parseSecond((List)pair.value);
                    }
                }
            }
            ++i;
        }
    }

    private void workOnItem(List list) {
        HashMap<String, String> item = new HashMap<String, String>();
        int i = 0;
        while (i < list.size()) {
            KeyValueAttributes pair = (KeyValueAttributes)list.get(i);
            if (pair.value instanceof String) {
                item.put(pair.key, (String)pair.value);
                if (pair.attributes != null) {
                    for (String key : pair.attributes.keySet()) {
                        item.put(key, (String)pair.attributes.get(key));
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.itemSynonymes.length) {
            if (item.get(this.itemSynonymes[i][0]) == null || item.get(this.itemSynonymes[i][0]).equals("")) {
                int j = 1;
                while (j < this.itemSynonymes[i].length) {
                    if (item.get(this.itemSynonymes[i][j]) != null && !item.get(this.itemSynonymes[i][j]).equals("")) {
                        item.put(this.itemSynonymes[i][0], (String)item.get(this.itemSynonymes[i][j]));
                        j = this.itemSynonymes[i].length;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.items.add(item);
    }

    private void workOnChannel(List list) {
        this.channel = new HashMap();
        int i = 0;
        while (i < list.size()) {
            KeyValueAttributes pair = (KeyValueAttributes)list.get(i);
            if (pair.key.equals("item")) {
                if (pair.value instanceof List) {
                    this.workOnItem((List)pair.value);
                }
            } else if (pair.value instanceof String) {
                this.channel.put(pair.key, (String)pair.value);
                if (pair.attributes != null) {
                    for (String key : pair.attributes.keySet()) {
                        this.channel.put(key, (String)pair.attributes.get(key));
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.channelSynonymes.length) {
            if (this.channel.get(this.channelSynonymes[i][0]) == null || this.channel.get(this.channelSynonymes[i][0]).equals("")) {
                int j = 1;
                while (j < this.channelSynonymes[i].length) {
                    if (this.channel.get(this.channelSynonymes[i][j]) != null && !this.channel.get(this.channelSynonymes[i][j]).equals("")) {
                        this.channel.put(this.channelSynonymes[i][0], this.channel.get(this.channelSynonymes[i][j]));
                        j = this.channelSynonymes[i].length;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Map parse(Reader in) throws XmlPullParserException, IOException {
        this.xmlPullParser.setInput(in);
        int type = this.xmlPullParser.next();
        if (type != 1) {
            List values = this.parseFirst(type);
            this.items = new ArrayList();
            this.parseSecond(values);
        }
        if (this.items == null || this.channel == null) {
            throw new XmlPullParserException("Error, channel or items is null");
        }
        this.channel.put("items", this.items);
        return this.channel;
    }

    public static void main(String[] args) throws XmlPullParserException, IOException {
        ChannelPullHandler handler = new ChannelPullHandler();
        FileReader in = new FileReader(args[0]);
        Map returnMap = handler.parse(in);
        int x = 3;
    }

    private class KeyValueAttributes {
        private String key = null;
        private Object value = null;
        private Map attributes = null;

        public KeyValueAttributes(String key, Object value, Map attributes) {
            this.key = key;
            this.value = value;
            this.attributes = attributes;
        }
    }
}

