/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class BestDeal {
    protected static final String MESSAGE = "The best deal is proposed by {0}. A(n) {1} delivered in {2,number,integer} days for {3,number,currency}";
    protected static final String NAMESPACE_URI = "http://www.psol.com/xbe2/listing8.3";
    public double price = Double.MAX_VALUE;
    public int delivery = Integer.MAX_VALUE;
    public String product = null;
    public String vendor = null;
    protected int targetDelivery;

    public BestDeal(int td) {
        this.targetDelivery = td;
    }

    public void update(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(0, null, null);
        parser.nextTag();
        parser.require(2, NAMESPACE_URI, "price-list");
        parser.nextTag();
        parser.require(2, NAMESPACE_URI, "name");
        this.product = parser.nextText();
        parser.require(3, NAMESPACE_URI, "name");
        while (parser.nextTag() == 2) {
            this.checkVendor(parser);
        }
        parser.require(3, NAMESPACE_URI, "price-list");
        parser.next();
        parser.require(1, null, null);
    }

    public void checkVendor(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, NAMESPACE_URI, "vendor");
        String currentVendor = null;
        while (parser.nextTag() == 2) {
            parser.require(2, NAMESPACE_URI, null);
            String name = parser.getName();
            if (name.equals("name")) {
                currentVendor = parser.nextText();
            } else if (name.equals("price-quote")) {
                int currentDelivery = Integer.parseInt(parser.getAttributeValue("", "delivery"));
                double currentPrice = Double.parseDouble(parser.nextText());
                if (currentDelivery < this.targetDelivery && currentPrice < this.price) {
                    this.vendor = currentVendor;
                    this.price = currentPrice;
                    this.delivery = currentDelivery;
                }
            } else {
                System.out.println("trying to skip unknwon element: " + name);
                String content = parser.nextText();
                System.out.println("skipped element content:" + content);
            }
            parser.require(3, NAMESPACE_URI, name);
        }
        parser.require(3, NAMESPACE_URI, "vendor");
    }

    public static void main(String[] args) throws IOException, XmlPullParserException {
        if (args.length < 2) {
            System.out.println("BestDeal <file> <delivery>");
            return;
        }
        BestDeal bestDeal = new BestDeal(Integer.parseInt(args[1]));
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        FileInputStream is = new FileInputStream(args[0]);
        parser.setInput((InputStream)is, null);
        bestDeal.update(parser);
        ((InputStream)is).close();
        Object[] objects = new Object[]{bestDeal.vendor, bestDeal.product, new Integer(bestDeal.delivery), new Double(bestDeal.price)};
        System.out.println(MessageFormat.format(MESSAGE, objects));
    }
}

