/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.gridlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import xiaofei.library.gridlayout.R;

public class GridLayout
extends ViewGroup {
    private int mHorizontalSpacing = 0;
    private int mVerticalSpacing = 0;
    private int mNumColumns = 1;
    private int mNumRows = 1;

    public GridLayout(Context context) {
        this(context, null, 0);
    }

    public GridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GridLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayoutAttrs);
        this.mHorizontalSpacing = (int)a.getDimension(R.styleable.GridLayoutAttrs_horizontalSpacing, (float)this.mHorizontalSpacing);
        this.mVerticalSpacing = (int)a.getDimension(R.styleable.GridLayoutAttrs_verticalSpacing, (float)this.mVerticalSpacing);
        this.mNumColumns = a.getInteger(R.styleable.GridLayoutAttrs_numColumns, this.mNumColumns);
        this.mNumRows = a.getInteger(R.styleable.GridLayoutAttrs_numRows, this.mNumRows);
        a.recycle();
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("horizontalSpacing should not be less than 0.");
        }
        this.mHorizontalSpacing = horizontalSpacing;
        this.invalidate();
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("verticalSpacing should not be less than 0.");
        }
        this.mVerticalSpacing = verticalSpacing;
        this.invalidate();
    }

    public void setNumColumns(int numColumns) {
        if (numColumns < 0) {
            throw new IllegalArgumentException("numColumns should not be less than 0.");
        }
        if (this.getChildCount() > this.mNumRows * numColumns) {
            throw new IllegalArgumentException("GridLayout will not be able to contain the children.");
        }
        this.mNumColumns = numColumns;
        this.invalidate();
    }

    public void setNumRows(int numRows) {
        if (numRows < 0) {
            throw new IllegalArgumentException("numRows should not be less than 0.");
        }
        if (this.getChildCount() > numRows * this.mNumColumns) {
            throw new IllegalArgumentException("GridLayout will not be able to contain the children.");
        }
        this.mNumRows = numRows;
        this.invalidate();
    }

    private boolean isFull() {
        return this.getChildCount() >= this.mNumColumns * this.mNumRows;
    }

    public void addView(View child) {
        if (this.isFull()) {
            throw new UnsupportedOperationException("GridLayout is full.");
        }
        super.addView(child);
    }

    public void addView(View child, int index) {
        if (this.isFull()) {
            throw new UnsupportedOperationException("GridLayout is full.");
        }
        super.addView(child, index);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.isFull()) {
            throw new UnsupportedOperationException("GridLayout is full.");
        }
        super.addView(child, index, params);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.isFull()) {
            throw new UnsupportedOperationException("GridLayout is full.");
        }
        super.addView(child, params);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        ViewGroup.LayoutParams lp;
        View child;
        int i;
        int count = this.getChildCount();
        int childState = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int maxChildWidth = 0;
        int maxChildHeight = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int childWidth = Math.max(0, (width - paddingLeft - paddingRight - this.mHorizontalSpacing * (this.mNumColumns - 1)) / this.mNumColumns);
        int childHeight = Math.max(0, (height - paddingTop - paddingBottom - this.mVerticalSpacing * (this.mNumRows - 1)) / this.mNumRows);
        int parentWidthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)widthMode);
        int parentHeightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)heightMode);
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            lp = child.getLayoutParams();
            childWidthMeasureSpec = GridLayout.getChildMeasureSpec((int)parentWidthSpec, (int)0, (int)lp.width);
            childHeightMeasureSpec = GridLayout.getChildMeasureSpec((int)parentHeightSpec, (int)0, (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            maxChildWidth = Math.max(maxChildWidth, child.getMeasuredWidth());
            maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight());
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
        }
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            parentWidthSpec = View.MeasureSpec.makeMeasureSpec((int)maxChildWidth, (int)widthMode);
            parentHeightSpec = View.MeasureSpec.makeMeasureSpec((int)maxChildHeight, (int)heightMode);
            childState = 0;
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                lp = child.getLayoutParams();
                childWidthMeasureSpec = GridLayout.getChildMeasureSpec((int)parentWidthSpec, (int)0, (int)lp.width);
                childHeightMeasureSpec = GridLayout.getChildMeasureSpec((int)parentHeightSpec, (int)0, (int)lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                maxChildWidth = Math.max(maxChildWidth, child.getMeasuredWidth());
                maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight());
                childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            }
        }
        int maxWidth = Math.max(maxChildWidth * this.mNumColumns + this.mHorizontalSpacing * (this.mNumColumns - 1) + paddingLeft + paddingRight, this.getSuggestedMinimumWidth());
        int maxHeight = Math.max(maxChildHeight * this.mNumRows + this.mVerticalSpacing * (this.mNumRows - 1) + paddingTop + paddingBottom, this.getSuggestedMinimumHeight());
        int widthResult = widthMode == 0x40000000 ? width : maxWidth;
        int heightResult = heightMode == 0x40000000 ? height : maxHeight;
        this.setMeasuredDimension(ViewCompat.resolveSizeAndState((int)widthResult, (int)widthMeasureSpec, (int)childState), ViewCompat.resolveSizeAndState((int)heightResult, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int numRows = this.mNumRows;
        int numColumns = this.mNumColumns;
        int horizontalSpacing = this.mHorizontalSpacing;
        int verticalSpacing = this.mVerticalSpacing;
        int childWidth = (this.getMeasuredWidth() - paddingLeft - paddingRight - horizontalSpacing * (numColumns - 1)) / numColumns;
        int childHeight = (this.getMeasuredHeight() - paddingTop - paddingBottom - verticalSpacing * (numRows - 1)) / numRows;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int row = i / numColumns;
            int column = i % numColumns;
            if (child.getVisibility() == 8) continue;
            int childLeft = paddingLeft + column * (childWidth + horizontalSpacing);
            int childTop = paddingTop + row * (childHeight + verticalSpacing);
            int tmpWidth = Math.max(childWidth, child.getMeasuredWidth());
            int tmpHeight = Math.max(childHeight, child.getMeasuredHeight());
            child.layout(childLeft, childTop, childLeft + tmpWidth, childTop + tmpHeight);
        }
    }
}

