/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.concurrentutils;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Condition;
import xiaofei.library.concurrentutils.util.Function;
import xiaofei.library.concurrentutils.util.NonNullCondition;

public class AugmentedListCanary<T> {
    private final Condition<T> nonNullCondition = new NonNullCondition();
    private volatile CopyOnWriteArrayList<T> list = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Lock> locks = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<java.util.concurrent.locks.Condition> conditions = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(T o) {
        AugmentedListCanary augmentedListCanary = this;
        synchronized (augmentedListCanary) {
            this.list.add(o);
            ReentrantLock lock = new ReentrantLock();
            this.locks.add(lock);
            this.conditions.add(lock.newCondition());
            return this.list.size();
        }
    }

    public int size() {
        return this.list.size();
    }

    public T getNonNull(int index) {
        return this.get(index, this.nonNullCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index, Condition<? super T> condition) {
        T result = null;
        this.locks.get(index).lock();
        try {
            while (true) {
                T t = this.list.get(index);
                result = t;
                if (!condition.satisfy(t)) {
                    this.conditions.get(index).await();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.locks.get(index).unlock();
        }
        return result;
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public <R extends T> void set(int index, R o) {
        this.locks.get(index).lock();
        this.list.set(index, o);
        this.conditions.get(index).signalAll();
        this.locks.get(index).unlock();
    }

    public T getAndSet(int index, Function<? super T, ? extends T> function) {
        this.locks.get(index).lock();
        T result = this.list.get(index);
        this.list.set(index, function.call(result));
        this.conditions.get(index).signalAll();
        this.locks.get(index).unlock();
        return result;
    }

    public void action(int index, Action<? super T> action) {
        this.locks.get(index).lock();
        action.call(this.list.get(index));
        this.conditions.get(index).signalAll();
        this.locks.get(index).unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(int index, Condition<? super T> condition) {
        this.locks.get(index).lock();
        try {
            while (!condition.satisfy(this.list.get(index))) {
                this.conditions.get(index).await();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.locks.get(index).unlock();
        }
    }

    public boolean satisfy(int index, Condition<? super T> condition) {
        this.locks.get(index).lock();
        boolean result = condition.satisfy(this.list.get(index));
        this.locks.get(index).unlock();
        return result;
    }
}

