/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.concurrentutils;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Condition;
import xiaofei.library.concurrentutils.util.Function;

public class ObjectCanary<T> {
    private final Condition<T> nonNullCondition = new Condition<T>(){

        @Override
        public boolean satisfy(T o) {
            return o != null;
        }
    };
    private volatile T object;
    private final Lock lock;
    private final java.util.concurrent.locks.Condition condition;

    public ObjectCanary(T object) {
        this.object = object;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public ObjectCanary() {
        this(null);
    }

    public void actionNonNull(Action<? super T> action) {
        this.action(action, this.nonNullCondition);
    }

    public void action(Action<? super T> action) {
        this.action(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action(Action<? super T> action, Condition<? super T> condition) {
        this.lock.lock();
        try {
            while (condition != null && !condition.satisfy(this.object)) {
                this.condition.await();
            }
            action.call(this.object);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public <R> R calculateNonNull(Function<? super T, ? extends R> function) {
        return this.calculate(function, this.nonNullCondition);
    }

    public <R> R calculate(Function<? super T, ? extends R> function) {
        return this.calculate(function, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R calculate(Function<? super T, ? extends R> function, Condition<? super T> condition) {
        R result = null;
        this.lock.lock();
        try {
            while (condition != null && !condition.satisfy(this.object)) {
                this.condition.await();
            }
            result = function.call(this.object);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public void wait(Condition<? super T> condition) {
        this.lock.lock();
        try {
            while (!condition.satisfy(this.object)) {
                this.condition.await();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitUntilNonNull() {
        this.wait(this.nonNullCondition);
    }

    public boolean satisfy(Condition<T> condition) {
        this.lock.lock();
        boolean result = condition.satisfy(this.object);
        this.lock.unlock();
        return result;
    }

    public void set(T object) {
        this.lock.lock();
        this.object = object;
        this.condition.signalAll();
        this.lock.unlock();
    }
}

