/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.util;

public class CodeUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private CodeUtils() {
    }

    public static String encode(byte[] input) {
        if (input.length < 0) {
            throw new IllegalArgumentException("Input length is less than 0.");
        }
        StringBuilder result = new StringBuilder();
        int len = input.length;
        for (int i = 0; i < len; ++i) {
            result.append(DIGITS[(0xF0 & input[i]) >>> 4]).append(DIGITS[0xF & input[i]]);
        }
        return result.toString();
    }

    private static int charToInt(char ch) {
        return '0' <= ch && ch <= '9' ? ch - 48 : ch - 65 + 10;
    }

    public static byte[] decode(String input) {
        int len = input.length();
        if (len < 0 || len % 2 != 0) {
            throw new IllegalArgumentException("Input error.");
        }
        byte[] result = new byte[len / 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            int tmp = CodeUtils.charToInt(input.charAt(i++)) << 4;
            result[j++] = (byte)(tmp |= CodeUtils.charToInt(input.charAt(i++)));
        }
        return result;
    }
}

