/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.database;

import android.content.Context;
import android.database.sqlite.SQLiteFullException;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xiaofei.library.datastorage.annotation.AnnotationProcessor;
import xiaofei.library.datastorage.database.DbService;
import xiaofei.library.datastorage.database.IDbOperation;
import xiaofei.library.datastorage.util.Condition;

class DbCache
implements IDbOperation {
    private static volatile DbCache sInstance = null;
    private final ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private DbService mDatabase;
    private AnnotationProcessor mAnnotationProcessor;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> mCache = new ConcurrentHashMap();

    private DbCache(Context context) {
        try {
            this.mDatabase = DbService.getInstance(context);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.mDatabase = null;
        }
        this.mAnnotationProcessor = AnnotationProcessor.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DbCache getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<DbCache> clazz = DbCache.class;
        synchronized (DbCache.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DbCache(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private <T> void sync(Class<T> clazz) {
        String className = this.mAnnotationProcessor.getClassId(clazz);
        if (!this.mCache.containsKey(className)) {
            List<Object> list = this.mDatabase == null ? new ArrayList() : this.mDatabase.getAllObjects(clazz);
            ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>();
            for (Pair pair : list) {
                map.put(pair.first, pair.second);
            }
            this.mCache.putIfAbsent(className, map);
        }
    }

    @Override
    public void close() {
        this.operateDb(new Runnable(){

            @Override
            public void run() {
                DbCache.this.mDatabase.close();
            }
        });
    }

    private void operateDb(Runnable runnable) {
        this.operateDb(runnable, true);
    }

    private void operateDb(final Runnable runnable, final boolean needHandleException) {
        if (this.mDatabase == null) {
            return;
        }
        this.mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (SQLiteFullException exception) {
                    if (needHandleException) {
                        DbCache.this.updateAllObjects();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void deleteObject(final Class<T> clazz, final String objectId) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<String, Object> map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            if (map.containsKey(objectId)) {
                map.remove(objectId);
                this.operateDb(new Runnable(){

                    @Override
                    public void run() {
                        DbCache.this.mDatabase.deleteObject(clazz, objectId);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void deleteAllObjects(final Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<String, Object> map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            map.clear();
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.deleteAllObjects(clazz);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void deleteObjects(final Class<T> clazz, final List<String> objectIds) {
        if (clazz == null || objectIds == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            Map map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            for (String id : objectIds) {
                if (id == null) continue;
                map.remove(id);
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.deleteObjects(clazz, objectIds);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void deleteObjects(Class<T> clazz, Condition<T> condition) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            Map map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            Set entries = map.entrySet();
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry entry : entries) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null || condition != null && !condition.satisfy(clazz.cast(entry.getValue()))) continue;
                ids.add((String)entry.getKey());
            }
            if (!ids.isEmpty()) {
                this.deleteObjects(clazz, ids);
            }
        }
    }

    @Override
    public <T> boolean containsObject(Class<T> clazz, String objectId) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
        return map.containsKey(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void insertObject(final T object, final String objectId) {
        if (object == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(object.getClass());
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            this.mCache.get(this.mAnnotationProcessor.getClassId(object.getClass())).put(objectId, object);
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.insertObject(object, objectId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void insertObjects(final List<T> objects, final List<String> objectIds) {
        if (objects == null || objectIds == null || objects.size() != objectIds.size()) {
            throw new IllegalArgumentException();
        }
        if (objects.isEmpty()) {
            return;
        }
        Class<?> clazz = objects.get(0).getClass();
        this.sync(clazz);
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            String className = this.mAnnotationProcessor.getClassId(clazz);
            Map map = this.mCache.get(className);
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                String id = objectIds.get(i);
                T value = objects.get(i);
                if (value == null || TextUtils.isEmpty((CharSequence)id)) {
                    throw new IllegalArgumentException();
                }
                if (value.getClass() != clazz) {
                    throw new IllegalArgumentException();
                }
                map.put(id, value);
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.insertObjects(objects, objectIds);
                }
            });
        }
    }

    @Override
    public <T> List<Pair<String, T>> getAllObjects(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        String className = this.mAnnotationProcessor.getClassId(clazz);
        ConcurrentHashMap<String, Object> map = this.mCache.get(className);
        LinkedList<Pair<String, T>> result = new LinkedList<Pair<String, T>>();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            result.add(new Pair((Object)entry.getKey(), clazz.cast(entry.getValue())));
        }
        return result;
    }

    @Override
    public <T> T getObject(Class<T> clazz, String objectId) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        String className = this.mAnnotationProcessor.getClassId(clazz);
        ConcurrentHashMap<String, Object> map = this.mCache.get(className);
        return clazz.cast(map.get(objectId));
    }

    @Override
    public <T> List<Pair<String, T>> getObjects(Class<T> clazz, Condition<T> condition) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        ConcurrentHashMap<String, Object> map = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
        LinkedList<Pair<String, T>> result = new LinkedList<Pair<String, T>>();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            T value;
            if (entry == null || (value = clazz.cast(entry.getValue())) == null || condition != null && !condition.satisfy(value)) continue;
            result.add(new Pair((Object)entry.getKey(), value));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTable() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            Collection<ConcurrentHashMap<String, Object>> maps = this.mCache.values();
            for (ConcurrentHashMap<String, Object> map : maps) {
                map.clear();
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.clearTable();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = this.mCache;
        synchronized (concurrentHashMap) {
            this.mCache.clear();
        }
    }

    public void updateAllObjects() {
        this.operateDb(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConcurrentHashMap concurrentHashMap = DbCache.this.mCache;
                synchronized (concurrentHashMap) {
                    DbCache.this.mDatabase.clearTable();
                    for (ConcurrentHashMap map : DbCache.this.mCache.values()) {
                        Set entries;
                        if (map == null || (entries = map.entrySet()).isEmpty()) continue;
                        ArrayList<String> ids = new ArrayList<String>();
                        ArrayList objects = new ArrayList();
                        for (Map.Entry entry : entries) {
                            String id = (String)entry.getKey();
                            Object object = entry.getValue();
                            if (id == null || object == null) continue;
                            ids.add(id);
                            objects.add(object);
                        }
                        DbCache.this.mDatabase.insertObjects(objects, ids);
                    }
                }
            }
        }, false);
    }
}

