/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import xiaofei.library.datastorage.annotation.ClassId;
import xiaofei.library.datastorage.annotation.FieldMember;
import xiaofei.library.datastorage.annotation.Member;
import xiaofei.library.datastorage.annotation.MethodMember;
import xiaofei.library.datastorage.annotation.ObjectId;

public class AnnotationProcessor {
    private final ConcurrentHashMap<Class<?>, String> mClassIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Member> mObjectIdMap = new ConcurrentHashMap();
    private static volatile AnnotationProcessor sInstance = null;

    private AnnotationProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnnotationProcessor getInstance() {
        if (sInstance != null) return sInstance;
        Class<AnnotationProcessor> clazz = AnnotationProcessor.class;
        synchronized (AnnotationProcessor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AnnotationProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public String getClassId(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        String className = this.mClassIdMap.get(clazz);
        if (className != null) {
            return className;
        }
        ClassId classIdAnnotation = clazz.getAnnotation(ClassId.class);
        className = classIdAnnotation == null ? clazz.getName() : classIdAnnotation.value();
        this.mClassIdMap.put(clazz, className);
        return className;
    }

    public String getObjectId(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = object.getClass();
        Member member = this.mObjectIdMap.get(clazz);
        if (member != null) {
            return (String)member.getValue(object);
        }
        member = this.getObjectIdMember(clazz);
        if (member == null) {
            throw new IllegalArgumentException("Object does not have an object id. Please specify an object id when invoking method. Otherwise you can add @ObjectId on the field or the non-arg method which provides the object id.");
        }
        this.mObjectIdMap.put(clazz, member);
        return (String)member.getValue(object);
    }

    private Member getObjectIdMember(Class<?> clazz) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ObjectId.class) || field.getType() != String.class) continue;
            return new FieldMember(field);
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(ObjectId.class) || method.getParameterTypes().length != 0 || method.getReturnType() != String.class) continue;
            return new MethodMember(method);
        }
        return null;
    }
}

