/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.util.Pair;
import java.util.LinkedList;
import java.util.List;
import xiaofei.library.datastorage.annotation.AnnotationProcessor;
import xiaofei.library.datastorage.database.DbOpenHelper;
import xiaofei.library.datastorage.database.GsonObjectCoder;
import xiaofei.library.datastorage.database.GzipCoderHook;
import xiaofei.library.datastorage.database.IDbOperation;
import xiaofei.library.datastorage.util.Condition;

public class DbService
implements IDbOperation {
    private Coder mCoder = null;
    private static final String EQUAL = "` = '";
    private static DbService sInstance;
    private DbOpenHelper mDatabaseHelper;
    private AnnotationProcessor mAnnotationProcessor;
    private SQLiteDatabase mDb = null;

    private DbService(Context context) {
        this.mDatabaseHelper = new DbOpenHelper(context);
        this.mDb = this.mDatabaseHelper.getWritableDatabase();
        this.mCoder = new GsonObjectCoder(new GzipCoderHook());
        this.mAnnotationProcessor = AnnotationProcessor.getInstance();
    }

    static synchronized DbService getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DbService(context);
        }
        return sInstance;
    }

    void setCoder(Coder coder) {
        this.mCoder = coder;
    }

    private static String generateEquation(String leftValue, String rightValue) {
        return "`" + leftValue + EQUAL + rightValue + "'";
    }

    private <T> String generateReplaceValue(T object, String id) {
        return "('" + this.mAnnotationProcessor.getClassId(object.getClass()) + "', '" + id + "', '" + this.mCoder.encode(object) + "')";
    }

    @Override
    public void close() {
        this.mDb.close();
    }

    @Override
    public <T> boolean containsObject(Class<T> clazz, String objectId) {
        Cursor c = this.mDb.query("data_storage", null, DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)) + " and " + DbService.generateEquation("object_id", objectId), null, null, null, null, null);
        boolean result = c.getCount() != 0;
        c.close();
        return result;
    }

    @Override
    public <T> void insertObject(T object, String objectId) {
        String command = "REPLACE INTO data_storage (`class_id`, `object_id`, `object_dat`)\nVALUES " + this.generateReplaceValue(object, objectId) + ";";
        this.mDb.execSQL(command);
    }

    @Override
    public <T> void insertObjects(final List<T> objects, final List<String> objectIds) {
        if (objects.isEmpty()) {
            return;
        }
        this.executeInTransaction(new Runnable(){

            @Override
            public void run() {
                int size = objects.size();
                for (int i = 0; i < size; ++i) {
                    Object object = objects.get(i);
                    String id = (String)objectIds.get(i);
                    DbService.this.insertObject(object, id);
                }
            }
        });
    }

    @Override
    public <T> List<Pair<String, T>> getAllObjects(Class<T> clazz) {
        LinkedList<Pair<String, T>> list = new LinkedList<Pair<String, T>>();
        Cursor cursor = this.mDb.query("data_storage", null, DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)), null, null, null, null);
        while (cursor.moveToNext()) {
            String data = cursor.getString(cursor.getColumnIndex("object_dat"));
            String id = cursor.getString(cursor.getColumnIndex("object_id"));
            Object object = null;
            try {
                object = this.mCoder.decode(data, clazz);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (object == null) continue;
            list.add(new Pair((Object)id, object));
        }
        cursor.close();
        return list;
    }

    @Override
    public <T> T getObject(Class<T> clazz, String objectIds) {
        T result = null;
        Cursor cursor = this.mDb.query("data_storage", null, DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)) + " and " + DbService.generateEquation("object_id", objectIds), null, null, null, null);
        if (cursor.moveToNext()) {
            String data = cursor.getString(cursor.getColumnIndex("object_dat"));
            try {
                result = this.mCoder.decode(data, clazz);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        cursor.close();
        return result;
    }

    @Override
    public <T> List<Pair<String, T>> getObjects(Class<T> clazz, Condition<T> condition) {
        LinkedList<Pair<String, T>> result = new LinkedList<Pair<String, T>>();
        Cursor cursor = this.mDb.query("data_storage", null, DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)), null, null, null, null);
        while (cursor.moveToNext()) {
            String data = cursor.getString(cursor.getColumnIndex("object_dat"));
            Object object = null;
            try {
                object = this.mCoder.decode(data, clazz);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (object == null || condition != null && (condition == null || !condition.satisfy(object))) continue;
            String id = cursor.getString(cursor.getColumnIndex("object_id"));
            result.add(new Pair((Object)id, object));
        }
        return result;
    }

    @Override
    public <T> void replaceObjects(final Class<T> clazz, final List<String> oldObjectIds, final List<T> newObjects, final List<String> newObjectIds) {
        this.executeInTransaction(new Runnable(){

            @Override
            public void run() {
                DbService.this.deleteObjects(clazz, oldObjectIds);
                DbService.this.insertObjects(newObjects, newObjectIds);
            }
        });
    }

    @Override
    public void clearTable() {
        this.mDb.delete("data_storage", null, null);
    }

    @Override
    public <T> void deleteObject(Class<T> clazz, String objectId) {
        String whereClause = DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)) + " and " + DbService.generateEquation("object_id", objectId);
        this.mDb.delete("data_storage", whereClause, null);
    }

    @Override
    public <T> void deleteObjects(Class<T> clazz, List<String> objectIds) {
        if (objectIds.isEmpty()) {
            return;
        }
        StringBuilder whereClause = new StringBuilder(DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz)) + " and `" + "object_id" + "` in ('" + objectIds.get(0) + "'");
        int size = objectIds.size();
        for (int i = 1; i < size; ++i) {
            whereClause.append(" ,'").append(objectIds.get(i)).append("'");
        }
        whereClause.append(")");
        this.mDb.delete("data_storage", whereClause.toString(), null);
    }

    @Override
    public <T> void deleteAllObjects(Class<T> clazz) {
        String whereClause = DbService.generateEquation("class_id", this.mAnnotationProcessor.getClassId(clazz));
        this.mDb.delete("data_storage", whereClause, null);
    }

    public void executeInTransaction(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mDb.beginTransaction();
            try {
                runnable.run();
                this.mDb.setTransactionSuccessful();
            }
            finally {
                this.mDb.endTransaction();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static interface Coder {
        public String encode(Object var1);

        public <T> T decode(String var1, Class<T> var2);
    }
}

