/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import xiaofei.library.datastorage.annotation.ClassId;
import xiaofei.library.datastorage.annotation.FieldMember;
import xiaofei.library.datastorage.annotation.Member;
import xiaofei.library.datastorage.annotation.MethodMember;
import xiaofei.library.datastorage.annotation.ObjectId;

public class AnnotationProcessor {
    private Map<Class<?>, String> mClassIdMap = new HashMap();
    private Map<Class<?>, Member> mObjectIdMap = new HashMap();
    private static AnnotationProcessor sInstance = null;

    private AnnotationProcessor() {
    }

    public static synchronized AnnotationProcessor getInstance() {
        if (sInstance == null) {
            sInstance = new AnnotationProcessor();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassId(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Map<Class<?>, String> map = this.mClassIdMap;
        synchronized (map) {
            String className = this.mClassIdMap.get(clazz);
            if (className != null) {
                return className;
            }
            ClassId classIdAnnotation = clazz.getAnnotation(ClassId.class);
            className = classIdAnnotation == null ? clazz.getName() : classIdAnnotation.value();
            this.mClassIdMap.put(clazz, className);
            return className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = object.getClass();
        Map<Class<?>, Member> map = this.mObjectIdMap;
        synchronized (map) {
            Member member = this.mObjectIdMap.get(clazz);
            if (member != null) {
                return (String)member.getValue(object);
            }
            member = this.getObjectIdMember(clazz);
            if (member == null) {
                throw new IllegalArgumentException("Object does not have an object id. Please specify an object id when invoking method. Otherwise you can add @ObjectId on the field or the non-arg method which provides the object id.");
            }
            this.mObjectIdMap.put(clazz, member);
            return (String)member.getValue(object);
        }
    }

    private Member getObjectIdMember(Class<?> clazz) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ObjectId.class) || field.getType() != String.class) continue;
            return new FieldMember(field);
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!method.isAnnotationPresent(ObjectId.class) || method.getParameterTypes().length != 0 || method.getReturnType() != String.class) continue;
            return new MethodMember(method);
        }
        return null;
    }
}

