/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.annotation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import xiaofei.library.datastorage.annotation.ClassId;
import xiaofei.library.datastorage.annotation.ObjectId;

public class AnnotationProcessor {
    private Map<Class<?>, String> mClassIdMap = new HashMap();
    private Map<Class<?>, Field> mObjectIdMap = new HashMap();
    private static AnnotationProcessor sInstance = null;

    private AnnotationProcessor() {
    }

    public static synchronized AnnotationProcessor getInstance() {
        if (sInstance == null) {
            sInstance = new AnnotationProcessor();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassId(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Map<Class<?>, String> map = this.mClassIdMap;
        synchronized (map) {
            String className = this.mClassIdMap.get(clazz);
            if (className != null) {
                return className;
            }
            ClassId classIdAnnotation = clazz.getAnnotation(ClassId.class);
            className = classIdAnnotation == null ? clazz.getName() : classIdAnnotation.value();
            this.mClassIdMap.put(clazz, className);
            return className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = object.getClass();
        Map<Class<?>, Field> map = this.mObjectIdMap;
        synchronized (map) {
            Field field = this.mObjectIdMap.get(clazz);
            if (field != null) {
                try {
                    return (String)field.get(object);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                field = this.getObjectIdField(clazz);
                if (field == null) {
                    throw new IllegalArgumentException("Object does not have an object id.");
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                this.mObjectIdMap.put(clazz, field);
                try {
                    return (String)field.get(object);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new IllegalArgumentException("Object does not have an object id.");
    }

    private Field getObjectIdField(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ObjectId.class) || field.getType() != String.class) continue;
            return field;
        }
        return null;
    }
}

