/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.database;

import android.content.Context;
import android.database.sqlite.SQLiteFullException;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xiaofei.library.datastorage.annotation.AnnotationProcessor;
import xiaofei.library.datastorage.database.DbService;
import xiaofei.library.datastorage.database.IDbOperation;
import xiaofei.library.datastorage.util.Condition;

public class DbCache
implements IDbOperation {
    private static DbCache sInstance = null;
    private final ExecutorService mExecutorService = Executors.newSingleThreadExecutor();
    private DbService mDatabase;
    private AnnotationProcessor mAnnotationProcessor;
    private final Map<String, Map<String, Object>> mCache = new HashMap<String, Map<String, Object>>();

    private DbCache(Context context) {
        try {
            this.mDatabase = DbService.getInstance(context);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.mDatabase = null;
        }
        this.mAnnotationProcessor = AnnotationProcessor.getInstance();
    }

    static synchronized DbCache getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DbCache(context);
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(Class clazz) {
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            String className = this.mAnnotationProcessor.getClassId(clazz);
            if (!this.mCache.containsKey(className)) {
                List<Object> list = this.mDatabase == null ? new ArrayList() : this.mDatabase.getAllObjects(clazz);
                HashMap<Object, Object> map2 = new HashMap<Object, Object>();
                for (Pair pair : list) {
                    map2.put(pair.first, pair.second);
                }
                this.mCache.put(className, map2);
            }
        }
    }

    @Override
    public void close() {
        this.operateDb(new Runnable(){

            @Override
            public void run() {
                DbCache.this.mDatabase.close();
            }
        });
    }

    private void operateDb(Runnable runnable) {
        this.operateDb(runnable, true);
    }

    private void operateDb(final Runnable runnable, final boolean needHandleException) {
        if (this.mDatabase == null) {
            return;
        }
        this.mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (SQLiteFullException exception) {
                    if (needHandleException) {
                        DbCache.this.updateAllObjects();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(final Class clazz, final String objectId) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            if (map2.containsKey(objectId)) {
                map2.remove(objectId);
                this.operateDb(new Runnable(){

                    @Override
                    public void run() {
                        DbCache.this.mDatabase.deleteObject(clazz, objectId);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void deleteAllObjects(final Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            this.mCache.remove(this.mAnnotationProcessor.getClassId(clazz));
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.deleteAllObjects(clazz);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void deleteObjects(final Class<T> clazz, final List<String> objectIds) {
        if (clazz == null || objectIds == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            for (String id : objectIds) {
                if (id == null) continue;
                map2.remove(id);
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.deleteObjects(clazz, objectIds);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void deleteObjects(Class<T> clazz, Condition<T> condition) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            Collection<Object> objects = map2.values();
            ArrayList<String> ids = new ArrayList<String>();
            for (Object object : objects) {
                if (object == null || condition != null && !condition.satisfy(object)) continue;
                ids.add(this.mAnnotationProcessor.getObjectId(object));
            }
            if (!ids.isEmpty()) {
                this.deleteObjects(clazz, ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObject(Class clazz, String objectId) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            return map2.containsKey(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void insertObject(final T object, final String objectId) {
        if (object == null || TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException();
        }
        this.sync(object.getClass());
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            this.mCache.get(this.mAnnotationProcessor.getClassId(object.getClass())).put(objectId, object);
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.insertObject(object, objectId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void insertObjects(final List<T> objects, final List<String> objectIds) {
        if (objects == null || objectIds == null || objects.size() != objectIds.size()) {
            throw new IllegalArgumentException();
        }
        if (objects.isEmpty()) {
            return;
        }
        Class<?> clazz = objects.get(0).getClass();
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            String className = this.mAnnotationProcessor.getClassId(clazz);
            Map<String, Object> map2 = this.mCache.get(className);
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                String id = objectIds.get(i);
                T value = objects.get(i);
                if (value == null || TextUtils.isEmpty((CharSequence)id)) {
                    throw new IllegalArgumentException();
                }
                if (value.getClass() != clazz) {
                    throw new IllegalArgumentException();
                }
                map2.put(id, value);
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.insertObjects(objects, objectIds);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Pair<String, T>> getAllObjects(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            String className = this.mAnnotationProcessor.getClassId(clazz);
            Map<String, Object> map2 = this.mCache.get(className);
            LinkedList<Pair<String, T>> result = new LinkedList<Pair<String, T>>();
            Set<Map.Entry<String, Object>> entries = map2.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                result.add(new Pair((Object)entry.getKey(), entry.getValue()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(Class<T> clazz, String objectIds) {
        if (clazz == null || TextUtils.isEmpty((CharSequence)objectIds)) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            String className = this.mAnnotationProcessor.getClassId(clazz);
            Map<String, Object> map2 = this.mCache.get(className);
            return (T)map2.get(objectIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Pair<String, T>> getObjects(Class<T> clazz, Condition<T> condition) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            LinkedList<Pair<String, T>> result = new LinkedList<Pair<String, T>>();
            Set<Map.Entry<String, Object>> entries = map2.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value;
                if (entry == null || (value = entry.getValue()) == null || condition != null && (condition == null || !condition.satisfy(value))) continue;
                result.add(new Pair((Object)entry.getKey(), value));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void replaceObjects(final Class<T> clazz, final List<String> oldObjectIds, final List<T> newObjects, final List<String> newObjectIds) {
        if (clazz == null || oldObjectIds == null || newObjects == null || newObjectIds == null) {
            throw new IllegalArgumentException();
        }
        if (newObjects.size() != newObjectIds.size()) {
            throw new IllegalArgumentException();
        }
        this.sync(clazz);
        Map<String, Map<String, Object>> map = this.mCache;
        synchronized (map) {
            Map<String, Object> map2 = this.mCache.get(this.mAnnotationProcessor.getClassId(clazz));
            for (String id : oldObjectIds) {
                if (id == null) {
                    throw new IllegalArgumentException();
                }
                map2.remove(id);
            }
            int size = newObjects.size();
            for (int i = 0; i < size; ++i) {
                String id = newObjectIds.get(i);
                T value = newObjects.get(i);
                if (id == null || value == null) {
                    throw new IllegalArgumentException();
                }
                map2.put(id, value);
            }
            this.operateDb(new Runnable(){

                @Override
                public void run() {
                    DbCache.this.mDatabase.replaceObjects(clazz, oldObjectIds, newObjects, newObjectIds);
                }
            });
        }
    }

    @Override
    public void clearTable() {
        this.mCache.clear();
        this.operateDb(new Runnable(){

            @Override
            public void run() {
                DbCache.this.mDatabase.clearTable();
            }
        });
    }

    public void updateAllObjects() {
        this.operateDb(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = DbCache.this.mCache;
                synchronized (map) {
                    DbCache.this.mDatabase.clearTable();
                    for (Map map2 : DbCache.this.mCache.values()) {
                        Set entries;
                        if (map2 == null || (entries = map2.entrySet()).isEmpty()) continue;
                        ArrayList<String> ids = new ArrayList<String>();
                        ArrayList objects = new ArrayList();
                        for (Map.Entry entry : entries) {
                            String id = (String)entry.getKey();
                            Object object = entry.getValue();
                            if (id == null || object == null) continue;
                            ids.add(id);
                            objects.add(object);
                        }
                        DbCache.this.mDatabase.insertObjects(objects, ids);
                    }
                }
            }
        }, false);
    }
}

