/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.datastorage.database;

import android.content.Context;
import android.support.v4.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import xiaofei.library.datastorage.IDataStorage;
import xiaofei.library.datastorage.annotation.AnnotationProcessor;
import xiaofei.library.datastorage.database.DbCache;
import xiaofei.library.datastorage.util.Condition;

public class DatabaseStorage
implements IDataStorage {
    private static DatabaseStorage sInstance = null;
    private DbCache mCache;
    private AnnotationProcessor mAnnotationProcessor;

    private DatabaseStorage(Context context) {
        this.mCache = DbCache.getInstance(context);
        this.mAnnotationProcessor = AnnotationProcessor.getInstance();
    }

    public static synchronized DatabaseStorage getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DatabaseStorage(context);
        }
        return sInstance;
    }

    @Override
    public <T> boolean contains(T element) {
        String id = this.mAnnotationProcessor.getObjectId(element);
        return this.contains(element.getClass(), id);
    }

    @Override
    public <T> void storeOrUpdate(T element) {
        String id = this.mAnnotationProcessor.getObjectId(element);
        this.storeOrUpdate(element, id);
    }

    @Override
    public <T> void storeOrUpdate(List<T> list, List<String> ids) {
        this.mCache.insertObjects(list, ids);
    }

    @Override
    public <T> List<T> load(Class<T> clazz, List<String> ids) {
        return this.load(clazz, ids, null);
    }

    @Override
    public <T> List<T> load(Class<T> clazz, final List<String> ids, Comparator<T> comparator) {
        List<Pair<String, T>> list = this.mCache.getObjects(clazz, new Condition<T>(){

            @Override
            public boolean satisfy(T o) {
                String id = DatabaseStorage.this.mAnnotationProcessor.getObjectId(o);
                return ids.contains(id);
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<String, T> pair : list) {
            result.add(pair.second);
        }
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    @Override
    public <T> void storeOrUpdate(T element, String id) {
        this.mCache.insertObject(element, id);
    }

    @Override
    public <T> void storeOrUpdate(List<T> list) {
        ArrayList<String> ids = new ArrayList<String>();
        for (T element : list) {
            String id = this.mAnnotationProcessor.getObjectId(element);
            if (id == null) {
                throw new RuntimeException("Element " + element + " has not initialized its ID.");
            }
            ids.add(id);
        }
        this.storeOrUpdate(list, ids);
    }

    @Override
    public <T> T load(Class<T> clazz, String id) {
        return this.mCache.getObject(clazz, id);
    }

    @Override
    public <T> List<T> loadAll(Class<T> clazz) {
        return this.loadAll(clazz, null);
    }

    @Override
    public <T> List<T> loadAll(Class<T> clazz, Comparator<T> comparator) {
        List<Pair<String, T>> list = this.mCache.getAllObjects(clazz);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<String, T> pair : list) {
            result.add(pair.second);
        }
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    @Override
    public <T> List<T> load(Class<T> clazz, Condition<T> condition) {
        return this.load(clazz, condition, null);
    }

    @Override
    public <T> List<T> load(Class<T> clazz, Condition<T> condition, Comparator<T> comparator) {
        List<Pair<String, T>> list = this.mCache.getObjects(clazz, condition);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<String, T> pair : list) {
            result.add(pair.second);
        }
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    @Override
    public <T> void delete(Class<T> clazz, String id) {
        this.mCache.deleteObject((Class)clazz, id);
    }

    @Override
    public <T> void deleteAll(Class<T> clazz) {
        this.mCache.deleteAllObjects(clazz);
    }

    @Override
    public <T> boolean contains(Class<T> clazz, String id) {
        return this.mCache.containsObject((Class)clazz, id);
    }

    @Override
    public <T> void delete(T element) {
        String id = this.mAnnotationProcessor.getObjectId(element);
        this.mCache.deleteObject((Class)element.getClass(), id);
    }

    @Override
    public <T> void delete(Class<T> clazz, List<String> ids) {
        this.mCache.deleteObjects(clazz, ids);
    }

    @Override
    public <T> void delete(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        Class<?> clazz = list.get(0).getClass();
        for (T element : list) {
            if (element == null || element.getClass() != clazz) {
                throw new IllegalArgumentException();
            }
            ids.add(this.mAnnotationProcessor.getObjectId(element));
        }
        this.delete(clazz, ids);
    }

    @Override
    public <T> void delete(Class<T> clazz, Condition<T> condition) {
        this.mCache.deleteObjects(clazz, condition);
    }

    @Override
    public void clear() {
        this.mCache.clearTable();
    }
}

