/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.wsdl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.wsdl.AbstractWSDL;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl.WSDL11Transport;
import org.codehaus.xfire.wsdl.WSDLWriter;

public abstract class AbstractJavaWSDL
extends AbstractWSDL
implements WSDLWriter {
    private PortType portType;
    private Binding binding;
    private Collection transports;
    private Map wsdlOps;

    public AbstractJavaWSDL(JavaService service, Collection transports) throws WSDLException {
        super(service);
        this.transports = transports;
        this.wsdlOps = new HashMap();
        PortType portType = this.createAbstractInterface();
        this.createConcreteInterface(portType);
        this.writeDocument();
    }

    protected QName createJavaxQName(org.dom4j.QName qname) {
        return new QName(qname.getNamespaceURI(), qname.getName());
    }

    public PortType createAbstractInterface() throws WSDLException {
        JavaService service = (JavaService)this.getService();
        Definition def = this.getDefinition();
        QName portName = new QName(service.getDefaultNamespace(), service.getName() + "PortType");
        this.portType = def.createPortType();
        this.portType.setQName(portName);
        this.portType.setUndefined(false);
        def.addPortType(this.portType);
        Iterator itr = service.getOperations().iterator();
        while (itr.hasNext()) {
            Operation op = (Operation)itr.next();
            Message req = this.getInputMessage(op);
            def.addMessage(req);
            Message res = this.getOutputMessage(op);
            def.addMessage(res);
            javax.wsdl.Operation wsdlOp = this.createOperation(op, req, res);
            wsdlOp.setUndefined(false);
            this.portType.addOperation(wsdlOp);
            this.wsdlOps.put(op.getName(), wsdlOp);
        }
        return this.portType;
    }

    public void createConcreteInterface(PortType portType) {
        Transport transportObj;
        JavaService service = (JavaService)this.getService();
        Definition def = this.getDefinition();
        QName name = new QName(service.getDefaultNamespace(), service.getName());
        javax.wsdl.Service wsdlService = def.createService();
        wsdlService.setQName(name);
        Iterator itr = this.transports.iterator();
        while (itr.hasNext() && (transportObj = (Transport)itr.next()) instanceof WSDL11Transport) {
            WSDL11Transport transport = (WSDL11Transport)transportObj;
            Binding transportBinding = transport.createBinding(portType, (Service)service);
            Iterator oitr = service.getOperations().iterator();
            while (oitr.hasNext()) {
                Operation op = (Operation)oitr.next();
                javax.wsdl.Operation wsdlOp = (javax.wsdl.Operation)this.wsdlOps.get(op.getName());
                BindingOperation bop = transport.createBindingOperation(portType, wsdlOp, (Service)service);
                transportBinding.addBindingOperation(bop);
            }
            Port transportPort = transport.createPort(transportBinding, (Service)service);
            def.addBinding(transportBinding);
            wsdlService.addPort(transportPort);
        }
        def.addService(wsdlService);
    }

    private Message getOutputMessage(Operation op) {
        Message res = this.getDefinition().createMessage();
        res.setQName(new QName(this.getService().getDefaultNamespace(), op.getName() + "Response"));
        res.setUndefined(false);
        this.createOutputParts(res, op);
        return res;
    }

    private Message getInputMessage(Operation op) {
        Message req = this.getDefinition().createMessage();
        req.setQName(new QName(this.getService().getDefaultNamespace(), op.getName() + "Request"));
        req.setUndefined(false);
        this.createInputParts(req, op);
        return req;
    }

    protected abstract void createInputParts(Message var1, Operation var2);

    protected abstract void createOutputParts(Message var1, Operation var2);

    public javax.wsdl.Operation createOperation(Operation op, Message req, Message res) {
        Definition def = this.getDefinition();
        javax.wsdl.Operation wsdlOp = def.createOperation();
        Input input = def.createInput();
        input.setMessage(req);
        input.setName(req.getQName().getLocalPart());
        Output output = def.createOutput();
        output.setMessage(res);
        output.setName(res.getQName().getLocalPart());
        wsdlOp.setOutput(output);
        wsdlOp.setName(op.getName());
        wsdlOp.setInput(input);
        return wsdlOp;
    }
}

