/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.util.DateUtils;

public class LiteralWriter
implements MessageWriter {
    private XMLStreamWriter writer;
    private String namespace;
    private String name;
    private static Calendar calendar = Calendar.getInstance();

    public LiteralWriter(XMLStreamWriter writer, String name, String namespace) {
        this.writer = writer;
        this.namespace = namespace;
        this.name = name;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    public LiteralWriter(OutputStream os, String name, String namespace) throws XMLStreamException {
        XMLOutputFactory ofactory = XMLOutputFactory.newInstance();
        this.writer = ofactory.createXMLStreamWriter(os);
        this.namespace = namespace;
        this.name = name;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    private void writeStartElement() throws XMLStreamException {
        String prefix = this.writer.getPrefix(this.namespace);
        boolean writeNS = false;
        if (prefix == null) {
            prefix = "";
            this.writer.setPrefix(prefix, this.namespace);
            writeNS = true;
        }
        this.writer.writeStartElement("", this.name, this.namespace);
        if (writeNS) {
            this.writer.writeDefaultNamespace(this.namespace);
        }
    }

    public void writeValue(Object value) {
        try {
            if (value != null) {
                this.writer.writeCharacters(value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    public void writeValue(Object value, String ns, String attr) {
        try {
            if (value != null) {
                this.writer.writeAttribute(ns, attr, value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    public MessageWriter getChildWriter(String name) {
        return new LiteralWriter(this.writer, name, this.namespace);
    }

    public MessageWriter getChildWriter(String name, String ns) {
        return new LiteralWriter(this.writer, name, ns);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void writeValueAsCalendar(Calendar calendar) {
        this.writeValue(DateUtils.formatDateTime((Date)calendar.getTime()));
    }

    public void writeValueAsCalendar(Calendar calendar, String ns, String attr) {
        this.writeValue(DateUtils.formatDateTime((Date)calendar.getTime()));
    }

    public void writeValueAsInt(Integer i) {
        this.writeValue(i.toString());
    }

    public void writeValueAsInt(Integer i, String ns, String attr) {
        this.writeValue(i.toString());
    }

    public void writeValueAsDateTime(Date date) {
        this.writeValue(DateUtils.formatDateTime((Date)date));
    }

    public void writeValueAsDateTime(Date date, String ns, String attr) {
        this.writeValue(ns, attr, DateUtils.formatDateTime((Date)date));
    }

    public void writeValueAsDate(Date date) {
        this.writeValue(DateUtils.formatDate((Date)calendar.getTime()));
    }

    public void writeValueAsDate(Date date, String ns, String attr) {
        this.writeValue(DateUtils.formatDate((Date)calendar.getTime()), ns, attr);
    }

    public void writeValueAsDouble(Double d) {
        this.writeValue(d.toString());
    }

    public void writeValueAsDouble(Double d, String ns, String attr) {
        this.writeValue(d.toString(), ns, attr);
    }

    public void writeValueAsLong(Long l) {
        this.writeValue(l.toString());
    }

    public void writeValueAsLong(Long l, String ns, String attr) {
        this.writeValue(l.toString(), ns, attr);
    }

    public void writeValueAsFloat(Float f) {
        this.writeValue(f.toString());
    }

    public void writeValueAsFloat(Float f, String ns, String attr) {
        this.writeValue(f.toString(), ns, attr);
    }

    public void writeValueAsBoolean(boolean b) {
        this.writeValue(Boolean.toString(b));
    }

    public void writeValueAsBoolean(boolean b, String ns, String attr) {
        this.writeValue(Boolean.toString(b), ns, attr);
    }

    public void close() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", (Throwable)e);
        }
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.writer;
    }
}

