/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.util.DateUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class LiteralWriter
implements MessageWriter {
    private Element element;
    private Namespace namespace;
    private static Calendar calendar = Calendar.getInstance();

    public LiteralWriter(Element element) {
        this.element = element;
        this.namespace = element.getNamespace();
    }

    public void writeValue(Object value) {
        if (value != null) {
            this.getElement().setText(value.toString());
        }
    }

    public MessageWriter getWriter(String name) {
        Element child = this.element.addElement(new QName(name, this.namespace));
        return new LiteralWriter(child);
    }

    public String getNamespace() {
        return this.namespace.getURI();
    }

    public void setNamespace(String namespace) {
        this.namespace = NamespaceHelper.getNamespace((Element)this.getElement(), (String)namespace);
    }

    public void writeValueAsCalendar(Calendar calendar) {
        DateUtils.formatDateTime((Date)calendar.getTime());
    }

    public void writeValueAsInt(Integer i) {
        this.writeValue(i.toString());
    }

    public void writeValueAsDateTime(Date date) {
        this.writeValue(DateUtils.formatDateTime((Date)date));
    }

    public void writeValueAsDate(Date date) {
        DateUtils.formatDate((Date)calendar.getTime());
    }

    public Element getElement() {
        return this.element;
    }

    public List getWriters() {
        return null;
    }

    public void writeValueAsDouble(Double d) {
        this.writeValue(d.toString());
    }

    public void writeValueAsLong(Long l) {
        this.writeValue(l.toString());
    }

    public void writeValueAsFloat(Float f) {
        this.writeValue(f.toString());
    }

    public void writeValueAsBoolean(boolean b) {
        this.writeValue(Boolean.toString(b));
    }
}

