/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.mapping;

import java.util.Hashtable;
import java.util.Iterator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.xfire.java.mapping.AutoTypeMapping;
import org.codehaus.xfire.java.mapping.CustomTypeMapping;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.plexus.PlexusXFireComponent;
import org.dom4j.QName;

public class DefaultTypeMappingRegistry
extends PlexusXFireComponent
implements TypeMappingRegistry,
Configurable {
    private Hashtable registry = new Hashtable();
    private TypeMapping defaultTM;
    static /* synthetic */ Class class$org$codehaus$xfire$java$type$BooleanType;
    static /* synthetic */ Class class$org$codehaus$xfire$java$type$IntType;
    static /* synthetic */ Class class$org$codehaus$xfire$java$type$DoubleType;
    static /* synthetic */ Class class$org$codehaus$xfire$java$type$FloatType;
    static /* synthetic */ Class class$org$codehaus$xfire$java$type$LongType;

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        TypeMapping previous = (TypeMapping)this.registry.get(encodingStyleURI);
        mapping.setEncodingStyleURI(encodingStyleURI);
        this.registry.put(encodingStyleURI, mapping);
        return previous;
    }

    public void registerDefault(TypeMapping mapping) {
        this.defaultTM = mapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return this.registry.keySet().toArray(new String[0]);
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.registry.get(encodingStyleURI);
    }

    public TypeMapping createTypeMapping(boolean autoTypes) {
        return this.createTypeMapping(this.getDefaultTypeMapping(), autoTypes);
    }

    public TypeMapping createTypeMapping(String parentNamespace, boolean autoTypes) {
        return this.createTypeMapping(this.getTypeMapping(parentNamespace), autoTypes);
    }

    protected TypeMapping createTypeMapping(TypeMapping parent, boolean autoTypes) {
        if (autoTypes) {
            return new AutoTypeMapping(parent);
        }
        return new CustomTypeMapping(parent);
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        TypeMapping tm = (TypeMapping)this.registry.get(encodingStyleURI);
        this.registry.remove(encodingStyleURI);
        return tm;
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        int n = 0;
        Iterator itr = this.registry.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().equals(mapping)) continue;
            itr.remove();
            ++n;
        }
        return n > 0;
    }

    public void clear() {
        this.registry.clear();
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        PlexusConfiguration[] tmConfig = config.getChildren("typeMapping");
        int i = 0;
        while (i < tmConfig.length) {
            this.configureTypeMapping(tmConfig[i]);
            ++i;
        }
    }

    private void configureTypeMapping(PlexusConfiguration configuration) throws PlexusConfigurationException {
        TypeMapping tm = this.createTypeMapping(false);
        this.register(configuration.getAttribute("namespace"), tm);
        if (Boolean.valueOf(configuration.getAttribute("default", "false")).booleanValue()) {
            this.registerDefault(tm);
        }
        PlexusConfiguration[] types = configuration.getChildren("type");
        tm.register(Boolean.TYPE, QName.get((String)"boolean", (String)"http://www.w3.org/2001/XMLSchema"), class$org$codehaus$xfire$java$type$BooleanType == null ? (class$org$codehaus$xfire$java$type$BooleanType = DefaultTypeMappingRegistry.class$("org.codehaus.xfire.java.type.BooleanType")) : class$org$codehaus$xfire$java$type$BooleanType);
        tm.register(Integer.TYPE, QName.get((String)"int", (String)"http://www.w3.org/2001/XMLSchema"), class$org$codehaus$xfire$java$type$IntType == null ? (class$org$codehaus$xfire$java$type$IntType = DefaultTypeMappingRegistry.class$("org.codehaus.xfire.java.type.IntType")) : class$org$codehaus$xfire$java$type$IntType);
        tm.register(Double.TYPE, QName.get((String)"double", (String)"http://www.w3.org/2001/XMLSchema"), class$org$codehaus$xfire$java$type$DoubleType == null ? (class$org$codehaus$xfire$java$type$DoubleType = DefaultTypeMappingRegistry.class$("org.codehaus.xfire.java.type.DoubleType")) : class$org$codehaus$xfire$java$type$DoubleType);
        tm.register(Float.TYPE, QName.get((String)"float", (String)"http://www.w3.org/2001/XMLSchema"), class$org$codehaus$xfire$java$type$FloatType == null ? (class$org$codehaus$xfire$java$type$FloatType = DefaultTypeMappingRegistry.class$("org.codehaus.xfire.java.type.FloatType")) : class$org$codehaus$xfire$java$type$FloatType);
        tm.register(Long.TYPE, QName.get((String)"long", (String)"http://www.w3.org/2001/XMLSchema"), class$org$codehaus$xfire$java$type$LongType == null ? (class$org$codehaus$xfire$java$type$LongType = DefaultTypeMappingRegistry.class$("org.codehaus.xfire.java.type.LongType")) : class$org$codehaus$xfire$java$type$LongType);
        int i = 0;
        while (i < types.length) {
            this.configureType(types[i], tm);
            ++i;
        }
    }

    private void configureType(PlexusConfiguration configuration, TypeMapping tm) throws PlexusConfigurationException {
        try {
            String ns = configuration.getAttribute("namespace");
            String name = configuration.getAttribute("name");
            QName qname = QName.get((String)name, (String)ns);
            Class clazz = this.loadClass(configuration.getAttribute("class"));
            Class typeClass = this.loadClass(configuration.getAttribute("type"));
            tm.register(clazz, qname, typeClass);
            this.getLogger().debug("Registered " + typeClass.getName() + " for " + qname + " with class " + clazz.getName());
        }
        catch (Exception e) {
            if (e instanceof PlexusConfigurationException) {
                throw (PlexusConfigurationException)e;
            }
            throw new PlexusConfigurationException("Could not configure type.", (Throwable)e);
        }
    }

    private Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return this.getClass().getClassLoader().loadClass(className);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

