/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.dom.DOMHandler;
import org.codehaus.xfire.handler.dom.DOMPipelineHandler;
import org.codehaus.xfire.java.AbstractJavaService;
import org.codehaus.xfire.java.JavaServiceHandler;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.wsdl.WSDLBuilder;
import org.dom4j.QName;

public class XmlJavaService
extends AbstractJavaService
implements Configurable {
    private PlexusConfiguration[] types;
    private PlexusConfiguration[] handlers;

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        this.configureService(config);
        this.configureTypes(config);
        DOMPipelineHandler handler = new DOMPipelineHandler();
        this.setServiceHandler((Handler)handler);
        this.handlers = config.getChild("handlers").getChildren("handler");
    }

    private void configureService(PlexusConfiguration config) throws PlexusConfigurationException {
        this.setName(config.getChild("name").getValue());
        this.setDefaultNamespace(config.getChild("namespace").getValue(""));
        this.setWSDLURL(config.getChild("wsdlURL").getValue(""));
        this.setUse(config.getChild("use").getValue("literal"));
        this.setStyle(config.getChild("style").getValue("wrapped"));
        try {
            this.setServiceClass(config.getChild("serviceClass").getValue());
        }
        catch (ClassNotFoundException e) {
            throw new PlexusConfigurationException("Couldn't find service class.", (Throwable)e);
        }
        this.setProperty("allowedMethods", config.getChild("allowedMethods").getValue(""));
        String soapNS = config.getChild("soapVersion").getValue("1.1");
        if (soapNS.equals("1.1")) {
            this.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope");
            this.setFaultHandlerHint("1.1");
        } else if (soapNS.equals("1.2")) {
            this.setFaultHandlerHint("1.2");
            this.setSoapVersion("http://www.w3.org/2003/05/soap-envelope");
        } else {
            throw new PlexusConfigurationException("Invalid soap version.  Must be 1.1 or 1.2.");
        }
        this.setFaultHandlerHint(soapNS);
        this.setAutoTyped(Boolean.valueOf(config.getChild("autoTyped").getValue("false")));
    }

    private void configureTypes(PlexusConfiguration config) throws PlexusConfigurationException {
        this.types = config.getChild("types").getChildren("type");
    }

    public void initialize() throws Exception {
        int i;
        super.initialize();
        DOMPipelineHandler pipe = (DOMPipelineHandler)this.getServiceHandler();
        if (this.handlers != null && this.handlers.length > 0) {
            i = 0;
            while (i < this.handlers.length) {
                String hId = this.handlers[i].getValue();
                DOMHandler handler = (DOMHandler)this.getServiceLocator().lookup(DOMHandler.ROLE, hId);
                pipe.getHandlers().add(handler);
                ++i;
            }
        } else {
            pipe.getHandlers().add(new JavaServiceHandler());
        }
        i = 0;
        while (i < this.types.length) {
            this.initializeType(this.types[i], this.getTypeMapping());
            ++i;
        }
        this.setWSDLBuilder((WSDLBuilder)this.getServiceLocator().lookup(WSDLBuilder.ROLE, "java"));
    }

    private void initializeType(PlexusConfiguration configuration, TypeMapping tm) throws PlexusConfigurationException {
        try {
            String ns = configuration.getAttribute("namespace", this.getDefaultNamespace());
            String name = configuration.getAttribute("name");
            tm.register(this.loadClass(configuration.getAttribute("class")), QName.get((String)name, (String)ns), this.loadClass(configuration.getAttribute("type")));
        }
        catch (Exception e) {
            if (e instanceof PlexusConfigurationException) {
                throw (PlexusConfigurationException)e;
            }
            throw new PlexusConfigurationException("Could not configure type.", (Throwable)e);
        }
    }
}

