/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.FaultHandler;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.plexus.PlexusService;

public abstract class AbstractJavaService
extends PlexusService
implements JavaService {
    private TypeMapping typeMapping;
    private List allowedMethods = new ArrayList();
    private Class serviceClass;
    private Hashtable operations = new Hashtable();
    protected static final String SERVICE_CLASS = "serviceClass";
    protected static final String ALLOWED_METHODS = "allowedMethods";
    private boolean autoTyped = false;

    public void setServiceClass(String className) throws ClassNotFoundException {
        this.serviceClass = this.getClass().getClassLoader().loadClass(className);
        this.initializeOperations();
    }

    private void initializeOperations() {
        Method[] methods = this.serviceClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            if (this.isAllowed(methodName) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers)) {
                this.addOperation(method);
            }
            ++i;
        }
    }

    private void addOperation(Method method) {
        Operation op = new Operation(method, this);
        this.operations.put(method.getName(), op);
    }

    private boolean isAllowed(String methodName) {
        return this.allowedMethods.size() == 0 || this.allowedMethods.contains(methodName);
    }

    public Operation getOperation(String localName, String namespace) {
        return (Operation)this.operations.get(localName);
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return this.getClass().getClassLoader().loadClass(className);
    }

    public void initialize() throws Exception {
        TypeMapping tm = null;
        tm = this.getUse().equals("encoded") ? this.getTypeMappingRegistry().createTypeMapping("http://schemas.xmlsoap.org/soap/encoding/", this.autoTyped) : this.getTypeMappingRegistry().createTypeMapping("http://www.w3.org/2001/XMLSchema", this.autoTyped);
        this.setTypeMapping(tm);
        this.getTypeMappingRegistry().register(this.getDefaultNamespace(), tm);
        super.initialize();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        try {
            return (TypeMappingRegistry)this.getServiceLocator().lookup(TypeMappingRegistry.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("There is no type mapping registry!", e);
        }
    }

    public FaultHandler getFaultHandler() {
        try {
            return (FaultHandler)this.getServiceLocator().lookup(FaultHandler.ROLE, this.getFaultHandlerHint());
        }
        catch (ComponentLookupException e) {
            throw new XFireRuntimeException("Couldn't find fault handler!", (Throwable)e);
        }
    }

    public boolean isAutoTyped() {
        return this.autoTyped;
    }

    public void setAutoTyped(boolean autoTyped) {
        this.autoTyped = autoTyped;
    }
}

