/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.llom.SOAPElement;

public class SOAPEnvelopeImpl
extends SOAPElement
implements SOAPEnvelope,
OMConstants {
    public SOAPEnvelopeImpl(OMXMLParserWrapper builder, SOAPFactory factory) {
        super(null, "Envelope", builder, factory);
        this.factory = factory;
    }

    public SOAPEnvelopeImpl(OMNamespace ns, SOAPFactory factory) {
        super("Envelope", ns, factory);
        this.factory = factory;
    }

    public SOAPHeader getHeader() throws OMException {
        SOAPHeader header = (SOAPHeader)this.getFirstChildWithName(new QName("Header"));
        if (this.builder == null && header == null) {
            this.inferFactory();
            header = ((SOAPFactory)this.factory).createSOAPHeader(this);
            this.addChild(header);
        }
        return header;
    }

    private void inferFactory() {
        if (this.ns != null) {
            if ("http://www.w3.org/2003/05/soap-envelope".equals(this.ns.getNamespaceURI())) {
                this.factory = OMAbstractFactory.getSOAP12Factory();
            } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.ns.getNamespaceURI())) {
                this.factory = OMAbstractFactory.getSOAP11Factory();
            }
        }
    }

    public void addChild(OMNode child) {
        SOAPBody body;
        if (child instanceof OMElement && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPProcessingException("SOAP Envelope can not have children other than SOAP Header and Body", "Sender");
        }
        if (this.done && child instanceof SOAPHeader && (body = this.getBody()) != null) {
            body.insertSiblingBefore(child);
            return;
        }
        super.addChild(child);
    }

    public SOAPBody getBody() throws OMException {
        OMElement element = this.getFirstElement();
        if (element != null) {
            OMNode node;
            if ("Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            for (node = element.getNextOMSibling(); node != null && node.getType() != 1; node = node.getNextOMSibling()) {
            }
            element = (OMElement)node;
            if (node != null && "Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            throw new OMException("SOAPEnvelope must contain a body element which is either first or second child element of the SOAPEnvelope.");
        }
        return null;
    }

    public OMNode detach() throws OMException {
        return this;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
    }

    protected void internalSerialize(XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = (MTOMXMLStreamWriter)writer2;
        if (!writer.isIgnoreXMLDeclaration()) {
            String charSetEncoding = writer.getCharSetEncoding();
            String xmlVersion = writer.getXmlVersion();
            writer.getXmlStreamWriter().writeStartDocument(charSetEncoding == null ? "utf-8" : charSetEncoding, xmlVersion == null ? "1.0" : xmlVersion);
        }
        super.internalSerialize(writer, cache);
    }
}

