/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl.serialize;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.om.OMSerializer;
import org.apache.ws.commons.om.impl.OMOutputImpl;

public class StreamingOMSerializer
implements XMLStreamConstants,
OMSerializer {
    private static int namespaceSuffix = 0;
    public static final String NAMESPACE_PREFIX = "ns";
    private int depth = 0;

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, new OMOutputImpl(writer));
    }

    public void serialize(XMLStreamReader obj, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamReader node = obj;
        this.serializeNode(node, omOutput);
    }

    protected void serializeNode(XMLStreamReader reader, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                try {
                    this.serializeEndElement(writer);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String nameSpaceName = reader.getNamespaceURI();
        if (nameSpaceName != null) {
            String writer_prefix = writer.getPrefix(nameSpaceName);
            if (writer_prefix != null) {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
            } else if (prefix != null) {
                writer.writeStartElement(prefix, reader.getLocalName(), nameSpaceName);
                writer.writeNamespace(prefix, nameSpaceName);
                writer.setPrefix(prefix, nameSpaceName);
            } else {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
                writer.writeDefaultNamespace(nameSpaceName);
                writer.setDefaultNamespace(nameSpaceName);
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            if (namespacePrefix != null && namespacePrefix.length() == 0) continue;
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
        this.serializeAttributes(reader, writer);
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        String writerPrefix = null;
        for (int i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            namespaceName = reader.getAttributeNamespace(i);
            writerPrefix = writer.getNamespaceContext().getPrefix(namespaceName);
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer.writeAttribute(writerPrefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                writer.writeNamespace(prefix, namespaceName);
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    private void serializeNamespace(String prefix, String URI, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(URI);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, URI);
            writer.setPrefix(prefix, URI);
        }
    }
}

