/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.ws.commons.om.OMAbstractFactory;
import org.apache.ws.commons.om.OMDocument;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMException;
import org.apache.ws.commons.om.OMFactory;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;
import org.apache.ws.commons.om.OMText;
import org.apache.ws.commons.om.OMXMLParserWrapper;
import org.apache.ws.commons.om.impl.OMNodeEx;

public abstract class StAXBuilder
implements OMXMLParserWrapper {
    protected XMLStreamReader parser;
    protected OMFactory omfactory;
    protected OMNode lastNode;
    protected boolean done = false;
    protected boolean cache = true;
    protected boolean parserAccessed = false;
    protected OMDocument document;

    protected StAXBuilder(OMFactory ombuilderFactory, XMLStreamReader parser) {
        this.parser = parser;
        this.omfactory = ombuilderFactory;
    }

    protected StAXBuilder(XMLStreamReader parser) {
        this(OMAbstractFactory.getOMFactory(), parser);
    }

    public void setOmbuilderFactory(OMFactory ombuilderFactory) {
        this.omfactory = ombuilderFactory;
    }

    protected abstract void processNamespaceData(OMElement var1, boolean var2);

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            OMNamespace ns = null;
            String uri = this.parser.getAttributeNamespace(i);
            String prefix = this.parser.getAttributePrefix(i);
            if (uri != null && uri.hashCode() != 0 && (ns = node.findNamespace(uri, prefix)) == null) {
                ns = node.declareNamespace(uri, prefix);
            }
            node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), ns);
        }
    }

    protected OMNode createOMText(int textType) throws OMException {
        OMText node = null;
        if (this.lastNode == null) {
            return null;
        }
        if (!this.lastNode.isComplete()) {
            node = this.omfactory.createText((OMElement)this.lastNode, this.parser.getText(), textType);
        } else if (!(this.lastNode.getParent() instanceof OMDocument)) {
            node = this.omfactory.createText((OMElement)this.lastNode.getParent(), this.parser.getText(), textType);
        }
        return node;
    }

    public void reset(OMNode node) throws OMException {
        this.lastNode = null;
    }

    public void discard(OMElement el) throws OMException {
        OMNode element = null;
        if (element.isComplete() || !this.cache) {
            throw new OMException();
        }
        try {
            this.cache = false;
            while (this.parser.next() != 2 || !this.parser.getName().equals(element.getQName())) {
            }
            this.lastNode = element.getPreviousOMSibling();
            if (this.lastNode != null) {
                ((OMNodeEx)this.lastNode).setNextOMSibling(null);
            } else {
                OMElement parent = (OMElement)element.getParent();
                if (parent == null) {
                    throw new OMException();
                }
                parent.setFirstChild(null);
                this.lastNode = parent;
            }
            this.cache = true;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getText() throws OMException {
        return this.parser.getText();
    }

    public String getNamespace() throws OMException {
        return this.parser.getNamespaceURI();
    }

    public int getNamespaceCount() throws OMException {
        try {
            return this.parser.getNamespaceCount();
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespacePrefix(int index) throws OMException {
        try {
            return this.parser.getNamespacePrefix(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespaceUri(int index) throws OMException {
        try {
            return this.parser.getNamespaceURI(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public void setCache(boolean b) {
        if (this.parserAccessed && b) {
            throw new UnsupportedOperationException("parser accessed. cannot set cache");
        }
        this.cache = b;
    }

    public String getName() throws OMException {
        return this.parser.getLocalName();
    }

    public String getPrefix() throws OMException {
        return this.parser.getPrefix();
    }

    public int getAttributeCount() throws OMException {
        return this.parser.getAttributeCount();
    }

    public String getAttributeNamespace(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributeName(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributePrefix(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public Object getParser() {
        if (this.parserAccessed) {
            throw new IllegalStateException("Parser already accessed!");
        }
        if (!this.cache) {
            this.parserAccessed = true;
            return this.parser;
        }
        throw new IllegalStateException("cache must be switched off to access the parser");
    }

    public boolean isCompleted() {
        return this.done;
    }

    protected abstract OMNode createOMElement() throws OMException;

    public abstract int next() throws OMException;

    public short getBuilderType() {
        return 1;
    }

    public void registerExternalContentHandler(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object getRegisteredContentHandler() {
        throw new UnsupportedOperationException();
    }

    public OMDocument getDocument() {
        return this.document;
    }
}

