/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.cvm.Address;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.json.JSONReader;
import convex.core.util.JSON;
import convex.core.util.Utils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ConvexJSON {
    private final String url;
    private final HttpClient httpClient;
    private AKeyPair keyPair;
    private Address address;
    private Long sequence = null;

    private ConvexJSON(String peerServerURL) {
        this.url = peerServerURL;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
    }

    public static ConvexJSON connect(String peerServerURL, Address address, AKeyPair keyPair) {
        ConvexJSON convex = new ConvexJSON(peerServerURL);
        convex.setAddress(address);
        convex.setKeyPair(keyPair);
        return convex;
    }

    public static ConvexJSON connect(String peerServerURL) {
        ConvexJSON convex = new ConvexJSON(peerServerURL);
        return convex;
    }

    public Long getSequence() {
        if (this.address == null) {
            throw new IllegalStateException("Can't get sequence number because current Address is null");
        }
        if (this.sequence == null) {
            this.sequence = this.querySequence();
        }
        return this.sequence;
    }

    public long updateSequence(long seq) {
        if (this.sequence != null) {
            seq = Math.max(seq, this.sequence);
        }
        this.sequence = seq;
        return this.sequence;
    }

    public Address getAddress() {
        return this.address;
    }

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(AKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public synchronized void setAddress(Address addr) {
        if (this.address == addr) {
            return;
        }
        this.address = addr;
        this.sequence = null;
    }

    public Address useNewAccount() {
        AKeyPair keyPair = AKeyPair.generate();
        Address address = this.createAccount(keyPair);
        this.setAddress(address);
        this.setKeyPair(keyPair);
        this.sequence = 0L;
        return address;
    }

    public Address useNewAccount(long fundsRequested) {
        Address address = this.useNewAccount();
        this.faucet(address, fundsRequested);
        return address;
    }

    public Address createAccount(AKeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("createAccount requires a non-null valid keyPair");
        }
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("accountKey", keyPair.getAccountKey().toHexString());
        String json = JSON.toString(req);
        Map<String, Object> response = this.doPost(this.url + "/api/v1/createAccount", json);
        Address address = Address.parse((Object)response.get("address"));
        if (address == null) {
            throw new RuntimeException("Account creation failed: " + String.valueOf(response));
        }
        return address;
    }

    public Map<String, Object> query(String code) {
        String json = this.buildJsonQuery(this.address, code);
        return this.doPost(this.url + "/api/v1/query", json);
    }

    public Long querySequence() {
        Address addr = this.getAddress();
        Long seq = this.querySequence(addr);
        if (seq != null) {
            this.updateSequence(seq);
        }
        return seq;
    }

    public Long querySequence(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Non-null Address required");
        }
        Map<String, Object> response = this.queryAccount(address);
        if (response == null) {
            return null;
        }
        Long seq = (Long)response.get("sequence");
        return seq;
    }

    public Long queryBalance() {
        return this.queryBalance(this.getAddress());
    }

    public Long queryBalance(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Non-null Address required");
        }
        Map<String, Object> response = this.queryAccount(address);
        if (response == null) {
            return null;
        }
        return (Long)response.get("balance");
    }

    public Map<String, Object> queryAccount(Address address) {
        return this.queryAccount(address.longValue());
    }

    public Map<String, Object> queryAccount(long address) {
        Map<String, Object> result = this.doGet(this.url + "/api/v1/accounts/" + address);
        if (result.get("balance") == null) {
            return null;
        }
        return result;
    }

    public Map<String, Object> queryAccount() {
        if (this.address == null) {
            throw new IllegalStateException("No current Address set");
        }
        return this.queryAccount(this.address);
    }

    public Map<String, Object> faucet(Address address, long requestedAmount) {
        HashMap<String, Long> req = new HashMap<String, Long>();
        req.put("address", address.longValue());
        req.put("amount", requestedAmount);
        String json = JSON.toString(req);
        return this.doPost(this.url + "/api/v1/faucet", json);
    }

    public CompletableFuture<Map<String, Object>> queryAccountAsync(Address address) {
        return this.doGetAsync(this.url + "/api/v1/accounts/" + address.longValue());
    }

    public Map<String, Object> transact(String code) {
        try {
            CompletableFuture<Map<String, Object>> future = this.transactAsync(code);
            Map<String, Object> result = future.get();
            return result;
        }
        catch (Exception e) {
            return Result.fromException((Throwable)e).toJSON();
        }
    }

    public synchronized CompletableFuture<Map<String, Object>> transactAsync(String code) {
        String json = this.buildJsonQuery(this.address, code);
        CompletableFuture<Map<String, Object>> prep = this.doPostAsync(this.url + "/api/v1/transaction/prepare", json);
        return prep.thenCompose(r -> {
            ConvexJSON convexJSON = this;
            synchronized (convexJSON) {
                try {
                    Object hashHex;
                    Map result = r;
                    if (r == null) {
                        throw new Error("Null response from transaction prepare!: " + String.valueOf(r));
                    }
                    if (r.get("errorCode") != null) {
                        throw new Error("Error while preparing transaction: " + String.valueOf(r));
                    }
                    Long seq = (Long)r.get("sequence");
                    if (seq != null) {
                        this.updateSequence(seq);
                    }
                    if (!((hashHex = result.get("hash")) instanceof String)) {
                        throw new Error("No hash field containg hex string in response provided by server, got result: " + String.valueOf(r));
                    }
                    Blob hash = Blob.parse((String)((String)hashHex));
                    if (hash == null) {
                        throw new Error("Hash provided by server not valid hex, got: " + String.valueOf(hashHex));
                    }
                    CompletableFuture<Map<String, Object>> tr = this.submitAsync(hash);
                    return tr;
                }
                catch (Exception e) {
                    throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                }
            }
        });
    }

    private CompletableFuture<Map<String, Object>> submitAsync(Blob message) {
        ASignature sd = this.getKeyPair().sign((AArrayBlob)message);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("address", this.getAddress().longValue());
        req.put("hash", message.toHexString());
        req.put("accountKey", this.getKeyPair().getAccountKey().toHexString());
        req.put("sig", sd.toHexString());
        String json = JSON.toString(req);
        return this.doPostAsync(this.url + "/api/v1/transaction/submit", json);
    }

    public CompletableFuture<Map<String, Object>> queryAsync(String code) {
        String json = this.buildJsonQuery(this.address.longValue(), code);
        return this.doPostAsync(this.url + "/api/v1/query", json);
    }

    private String buildJsonQuery(Long a, String code) {
        HashMap<String, Object> req = new HashMap<String, Object>();
        if (a != null) {
            req.put("address", a);
        }
        req.put("source", code);
        String json = JSON.toString(req);
        return json;
    }

    private String buildJsonQuery(Address a, String code) {
        return this.buildJsonQuery(a == null ? null : Long.valueOf(a.longValue()), code);
    }

    private Map<String, Object> doPost(String endPoint, String json) {
        try {
            return this.doPostAsync(endPoint, json).get();
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private Map<String, Object> doGet(String endPoint) {
        try {
            return this.doGetAsync(endPoint).get();
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private CompletableFuture<Map<String, Object>> doPostAsync(String endPoint, String json) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endPoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        return this.doRequest(request);
    }

    private CompletableFuture<Map<String, Object>> doGetAsync(String endPoint) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endPoint)).GET().build();
        return this.doRequest(request);
    }

    private CompletableFuture<Map<String, Object>> doRequest(HttpRequest request) {
        try {
            CompletableFuture<HttpResponse<String>> future = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            return future.thenApply(response -> {
                String rbody = null;
                try {
                    rbody = (String)response.body();
                    ACell json = JSONReader.read((String)((String)response.body()));
                    return (Map)JSON.json((ACell)json);
                }
                catch (Exception e) {
                    if (rbody == null) {
                        rbody = "<Body not readable as String>";
                    }
                    Result res = Result.error((Keyword)ErrorCodes.FORMAT, (String)("Error in response " + String.valueOf(response) + " because can't parse body: " + rbody));
                    return res.toJSON();
                }
            });
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e).toJSON());
        }
    }
}

