/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.util.Shutdown;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;

public class HTTPClients {
    private static final CloseableHttpAsyncClient httpasyncclient = HttpAsyncClients.createDefault();

    public static CompletableFuture<SimpleHttpResponse> execute(SimpleHttpRequest request) {
        CompletableFuture<SimpleHttpResponse> future = HTTPClients.toCompletableFuture(fc -> httpasyncclient.execute(request, fc));
        return future;
    }

    private static <T> CompletableFuture<T> toCompletableFuture(Consumer<FutureCallback<T>> c) {
        final CompletableFuture promise = new CompletableFuture();
        c.accept(new FutureCallback<T>(){

            public void completed(T t) {
                promise.complete(t);
            }

            public void failed(Exception e) {
                promise.completeExceptionally(e);
            }

            public void cancelled() {
                promise.cancel(true);
            }
        });
        return promise;
    }

    static {
        Shutdown.addHook((int)60, () -> {
            try {
                httpasyncclient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        httpasyncclient.start();
    }
}

