/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.java.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;

public class Convex {
    private static final CloseableHttpAsyncClient httpasyncclient = HttpAsyncClients.createDefault();
    private final String url;
    private AKeyPair keyPair;
    private Address address;
    private Long sequence = null;

    private Convex(String peerServerURL) {
        this.url = peerServerURL;
    }

    public static Convex connect(String peerServerURL, Address address, AKeyPair keyPair) {
        Convex convex = new Convex(peerServerURL);
        convex.setAddress(address);
        convex.setKeyPair(keyPair);
        return convex;
    }

    public static Convex connect(String peerServerURL) {
        Convex convex = new Convex(peerServerURL);
        return convex;
    }

    public Long getSequence() {
        if (this.address == null) {
            throw new IllegalStateException("Can't get sequence number because current Address is null");
        }
        if (this.sequence == null) {
            this.sequence = this.querySequence();
        }
        return this.sequence;
    }

    public long updateSequence(long seq) {
        if (this.sequence != null) {
            seq = Math.max(seq, this.sequence);
        }
        this.sequence = seq;
        return this.sequence;
    }

    public Address getAddress() {
        return this.address;
    }

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(AKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public synchronized void setAddress(Address addr) {
        if (this.address == addr) {
            return;
        }
        this.address = addr;
        this.sequence = null;
    }

    public Address useNewAccount() {
        AKeyPair keyPair = AKeyPair.generate();
        Address address = this.createAccount(keyPair);
        this.setAddress(address);
        this.setKeyPair(keyPair);
        this.sequence = 0L;
        return address;
    }

    public Address useNewAccount(long fundsRequested) {
        Address address = this.useNewAccount();
        this.faucet(address, fundsRequested);
        return address;
    }

    public Address createAccount(AKeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("createAccount requires a non-null valid keyPair");
        }
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("accountKey", keyPair.getAccountKey().toHexString());
        String json = JSON.toPrettyString(req);
        Map<String, Object> response = this.doPost(this.url + "/api/v1/createAccount", json);
        Address address = Address.parse((Object)response.get("address"));
        if (address == null) {
            throw new RuntimeException("Account creation failed: " + response);
        }
        return address;
    }

    public Map<String, Object> query(String code) {
        String json = this.buildJsonQuery(this.address, code);
        return this.doPost(this.url + "/api/v1/query", json);
    }

    public Long querySequence() {
        Address addr = this.getAddress();
        Long seq = this.querySequence(addr);
        if (seq != null) {
            this.updateSequence(seq);
        }
        return seq;
    }

    public Long querySequence(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Non-null Address required");
        }
        Map<String, Object> response = this.queryAccount(address);
        if (response == null) {
            return null;
        }
        Long seq = (Long)response.get("sequence");
        return seq;
    }

    public Long queryBalance() {
        return this.queryBalance(this.getAddress());
    }

    public Long queryBalance(Address address) {
        if (address == null) {
            throw new IllegalArgumentException("Non-null Address required");
        }
        Map<String, Object> response = this.queryAccount(address);
        if (response == null) {
            return null;
        }
        return (Long)response.get("balance");
    }

    public Map<String, Object> queryAccount(Address address) {
        return this.queryAccount(address.longValue());
    }

    public Map<String, Object> queryAccount(long address) {
        Map<String, Object> result = this.doGet(this.url + "/api/v1/accounts/" + address);
        if (result.get("balance") == null) {
            return null;
        }
        return result;
    }

    public Map<String, Object> queryAccount() {
        if (this.address == null) {
            throw new IllegalStateException("No current Address set");
        }
        return this.queryAccount(this.address);
    }

    public Map<String, Object> faucet(Address address, long requestedAmount) {
        HashMap<String, Long> req = new HashMap<String, Long>();
        req.put("address", address.longValue());
        req.put("amount", requestedAmount);
        String json = JSON.toPrettyString(req);
        return this.doPost(this.url + "/api/v1/faucet", json);
    }

    public CompletableFuture<Map<String, Object>> queryAccountAsync(Address address) {
        return this.doGetAsync(this.url + "/api/v1/accounts/" + address.longValue());
    }

    public Map<String, Object> transact(String code) {
        try {
            CompletableFuture<Map<String, Object>> future = this.transactAsync(code);
            Map<String, Object> result = future.get();
            return result;
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    public synchronized CompletableFuture<Map<String, Object>> transactAsync(String code) {
        String json = this.buildJsonQuery(this.address, code);
        CompletableFuture<Map<String, Object>> prep = this.doPostAsync(this.url + "/api/v1/transaction/prepare", json);
        return prep.thenCompose(r -> {
            Convex convex = this;
            synchronized (convex) {
                Hash hash;
                Map result = r;
                if (r == null) {
                    throw new Error("Null response from transaction prepare!: " + r);
                }
                if (r.get("errorCode") != null) {
                    throw new Error("Error while preparing transaction: " + r);
                }
                Long seq = (Long)r.get("sequence");
                if (seq != null) {
                    this.updateSequence(seq);
                }
                if ((hash = Hash.parse(result.get("hash"))) == null) {
                    throw new Error("Valid transaction Hash not provided by server, got result: " + r);
                }
                try {
                    CompletableFuture<Map<String, Object>> tr = this.submitAsync(hash);
                    return tr;
                }
                catch (Throwable e) {
                    throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                }
            }
        });
    }

    private CompletableFuture<Map<String, Object>> submitAsync(Hash hash) {
        ASignature sd = this.getKeyPair().sign(hash);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("address", this.getAddress().longValue());
        req.put("hash", hash.toHexString());
        req.put("accountKey", this.getKeyPair().getAccountKey().toHexString());
        req.put("sig", sd.toHexString());
        String json = JSON.toPrettyString(req);
        return this.doPostAsync(this.url + "/api/v1/transaction/submit", json);
    }

    public CompletableFuture<Map<String, Object>> queryAsync(String code) {
        String json = this.buildJsonQuery(this.address.longValue(), code);
        return this.doPostAsync(this.url + "/api/v1/query", json);
    }

    private String buildJsonQuery(Long a, String code) {
        HashMap<String, Object> req = new HashMap<String, Object>();
        if (a != null) {
            req.put("address", a);
        }
        req.put("source", code);
        String json = JSON.toPrettyString(req);
        return json;
    }

    private String buildJsonQuery(Address a, String code) {
        return this.buildJsonQuery(a == null ? null : Long.valueOf(a.longValue()), code);
    }

    private Map<String, Object> doPost(String endPoint, String json) {
        try {
            return this.doPostAsync(endPoint, json).get();
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private Map<String, Object> doGet(String endPoint) {
        try {
            return this.doGetAsync(endPoint).get();
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private CompletableFuture<Map<String, Object>> doPostAsync(String endPoint, String json) {
        HttpPost post = new HttpPost(endPoint);
        return this.doRequest((HttpUriRequest)post, json);
    }

    private CompletableFuture<Map<String, Object>> doGetAsync(String endPoint) {
        HttpGet post = new HttpGet(endPoint);
        return this.doRequest((HttpUriRequest)post, null);
    }

    private CompletableFuture<Map<String, Object>> doRequest(HttpUriRequest request, String body) {
        try {
            if (body != null) {
                request.addHeader("content-type", "application/json");
                StringEntity entity = new StringEntity(body);
                ((HttpPost)request).setEntity((HttpEntity)entity);
            }
            CompletableFuture future = Convex.toCompletableFuture(fc -> httpasyncclient.execute(request, fc));
            return future.thenApply(response -> {
                String rbody = null;
                try {
                    InputStream is = response.getEntity().getContent();
                    rbody = Utils.readString((InputStream)is);
                    return (Map)JSON.parse(rbody);
                }
                catch (Exception e) {
                    if (rbody == null) {
                        rbody = "<Body not readable as String>";
                    }
                    throw new RuntimeException("Error in response " + response + " because can't parse body: " + rbody, e);
                }
            });
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private static <T> CompletableFuture<T> toCompletableFuture(Consumer<FutureCallback<T>> c) {
        final CompletableFuture promise = new CompletableFuture();
        c.accept(new FutureCallback<T>(){

            public void completed(T t) {
                promise.complete(t);
            }

            public void failed(Exception e) {
                promise.completeExceptionally(e);
            }

            public void cancelled() {
                promise.cancel(true);
            }
        });
        return promise;
    }

    static {
        httpasyncclient.start();
        Shutdown.addHook((int)60, () -> {
            try {
                httpasyncclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

