/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.core.util.Utils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSON {
    private static String WHITESPACE = "                                                             ";
    private static int WHITESPACE_LENGTH = WHITESPACE.length();

    public static Map<String, Object> toMap(String jsonString) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject result = (JSONObject)parser.parse(jsonString);
            return new JSONObject((Map)result);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error in JSON parsing: " + e.getMessage(), e);
        }
    }

    public static <T> T parse(String jsonString) {
        JSONParser parser = new JSONParser();
        try {
            Object result = parser.parse(jsonString);
            return (T)result;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error in JSON parsing: " + e.getMessage(), e);
        }
    }

    public static String toPrettyString(Object value) {
        StringBuilder sb = new StringBuilder();
        sb = JSON.appendPrettyString(sb, value, 0);
        return sb.toString();
    }

    public static String toString(Object value) {
        return JSONValue.toJSONString((Object)value);
    }

    private static StringBuilder appendPrettyString(StringBuilder sb, Object o, int indent) {
        if (o instanceof Map) {
            int entryIndent = indent + 2;
            sb.append("{\n");
            Map m = (Map)o;
            int size = m.size();
            int pos = 0;
            for (Map.Entry me : m.entrySet()) {
                String k = (String)me.getKey();
                sb = JSON.appendWhitespaceString(sb, entryIndent);
                sb.append(JSON.toString(k));
                sb.append(": ");
                int vIndent = entryIndent + k.length() + 4;
                Object v = me.getValue();
                JSON.appendPrettyString(sb, v, vIndent);
                if (++pos == size) {
                    sb.append('\n');
                    continue;
                }
                sb.append(",\n");
            }
            sb = JSON.appendWhitespaceString(sb, indent);
            sb.append("}");
        } else if (o instanceof List) {
            List list = (List)o;
            int size = list.size();
            int entryIndent = indent + 1;
            sb.append("[");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                    sb = JSON.appendWhitespaceString(sb, entryIndent);
                }
                Object v = list.get(i);
                sb = JSON.appendPrettyString(sb, v, entryIndent);
            }
            sb.append("]");
        } else {
            sb.append(JSON.toString(o));
        }
        return sb;
    }

    private static StringBuilder appendWhitespaceString(StringBuilder sb, int count) {
        while (count > WHITESPACE_LENGTH) {
            sb.append(WHITESPACE);
            count -= WHITESPACE_LENGTH;
        }
        sb.append(WHITESPACE, 0, count);
        return sb;
    }

    public static <T> T parse(InputStream content) {
        Object parsed;
        JSONParser parser = new JSONParser();
        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
        try {
            parsed = parser.parse((Reader)reader);
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        return (T)parsed;
    }
}

