/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.cli.CLIError;
import convex.cli.mixins.AMixin;
import convex.core.data.AccountKey;
import convex.core.store.AStore;
import convex.core.util.FileUtils;
import convex.etch.EtchStore;
import convex.peer.API;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class EtchMixin
extends AMixin {
    @CommandLine.Option(names={"-e", "--etch"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:CONVEX_ETCH_FILE:-~/.convex/etch.db}", description={"Etch database. Defaults to CONVEX_ETCH_FILE or ~/.convex/etch.db"})
    String etchStoreFilename;
    EtchStore etch = null;

    public synchronized EtchStore getEtchStore(String fileName) {
        if (this.etch != null) {
            return this.etch;
        }
        if (fileName == null) {
            throw new CLIError("No Etch store file specified. Maybe include --etch option or set environment variable CONVEX_ETCH_FILE ?");
        }
        File etchFile = null;
        try {
            if ("temp".equals(fileName)) {
                this.etch = EtchStore.createTemp((String)"tempCLIStore");
                return this.etch;
            }
            etchFile = FileUtils.getFile((String)fileName);
            this.etch = EtchStore.create((File)etchFile);
            return this.etch;
        }
        catch (IOException e) {
            throw new CLIError("Unable to load Etch store at: " + fileName + " due to " + String.valueOf(e), e);
        }
    }

    public EtchStore getEtchStore() {
        return this.getEtchStore(this.etchStoreFilename);
    }

    public List<AccountKey> getPeerList() {
        EtchStore etchStore = this.getEtchStore();
        try {
            ArrayList keys = API.listPeers((AStore)this.getEtchStore());
            return keys;
        }
        catch (IOException e) {
            throw new CLIError("Unable to list peers in store: " + String.valueOf(etchStore));
        }
    }
}

