/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.account;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.account.AAccountCommand;
import convex.cli.account.Account;
import convex.core.Result;
import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import picocli.CommandLine;

@CommandLine.Command(name="balance", aliases={"bal"}, mixinStandardHelpOptions=true, description={"Get account balance of the specified address."})
public class AccountBalance
extends AAccountCommand {
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Parameters(paramLabel="addresses", description={"Address(es) to query balance for. If omitted, will look for --address argument."})
    private String[] addresses;
    @CommandLine.Option(names={"-a", "--address"}, defaultValue="${env:CONVEX_ADDRESS}", description={"Account address to use for query. Can specify with CONVEX_ADDRESS environment variable."})
    protected String addressValue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws InterruptedException {
        Address address = Address.parse((String)this.addressValue);
        if (this.addresses == null) {
            if (address != null) {
                this.addresses = new String[]{address.toString()};
            } else {
                this.showUsage();
                throw new CLIError(64, "No addressed specified");
            }
        }
        int n = this.addresses.length;
        try (Convex convex = this.peerMixin.connect();){
            StringBuilder sb = new StringBuilder();
            sb.append("(map balance [");
            for (int i = 0; i < n; ++i) {
                String aString = this.addresses[i];
                Address addr = Address.parse((String)aString);
                if (addr == null) {
                    throw new CLIError(64, "Address not valid: " + aString);
                }
                sb.append(addr);
            }
            sb.append("])");
            ACell message = Reader.read((String)sb.toString());
            Result result = convex.querySync(message);
            if (result.isError()) {
                throw new CLIError("Balance query failed: " + result.toString());
            }
            AVector v = RT.ensureVector((ACell)result.getValue());
            if (v == null) {
                throw new CLIError(65, "Invalid result, expected vector of balances: " + String.valueOf(result));
            }
            for (int i = 0; i < n; ++i) {
                this.println(v.get(i));
            }
        }
    }
}

