/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.mixins.RemotePeerMixin;
import convex.cli.output.RecordOutput;
import convex.cli.peer.APeerCommand;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.cvm.Address;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.ACell;
import convex.core.exceptions.ResultException;
import convex.core.lang.Reader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create", mixinStandardHelpOptions=true, description={"Configures and creates a peer on a Convex network. Needs an esisting peer as --host and a valid peer controller account. Will generate a new peer key if not otherwise specified."})
public class PeerCreate
extends APeerCommand {
    private static final Logger log = LoggerFactory.getLogger(PeerCreate.class);
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    RemotePeerMixin peerMixin;

    @Override
    public void execute() throws InterruptedException {
        KeyStore keyStore;
        long peerStake = 1000000000000L;
        AKeyPair keyPair = null;
        try {
            keyStore = this.storeMixin.ensureKeyStore();
        }
        catch (Error e) {
            log.info(e.getMessage());
            return;
        }
        try {
            Convex convex = this.peerMixin.connect();
            keyPair = AKeyPair.generate();
            PFXTools.setKeyPair((KeyStore)keyStore, (AKeyPair)keyPair, (char[])this.keyMixin.getKeyPassword());
            this.storeMixin.saveKeyStore();
            this.inform("Created new peer key: " + String.valueOf(keyPair.getAccountKey()));
            Address address = convex.createAccountSync(keyPair.getAccountKey());
            convex.transferSync(address, peerStake);
            long stakeBalance = convex.getBalance(address);
            String accountKeyString = keyPair.getAccountKey().toHexString();
            long stakeAmount = (long)((double)stakeBalance * 0.98);
            String transactionCommand = String.format("(create-peer 0x%s %d)", accountKeyString, stakeAmount);
            ACell message = Reader.read((String)transactionCommand);
            Invoke transaction = Invoke.create((Address)address, (long)-1L, (ACell)message);
            Result result = convex.transactSync((ACell)transaction);
            if (result.isError()) {
                this.printResult(result);
                return;
            }
            long currentBalance = convex.getBalance(address);
            String shortAccountKey = accountKeyString.substring(0, 6);
            RecordOutput output = new RecordOutput();
            output.addField("Public Peer Key", keyPair.getAccountKey().toString());
            output.addField("Controller Address", address.longValue());
            output.addField("Balance", currentBalance);
            output.addField("Inital stake amount", stakeAmount);
            output.addField("Peer start line", String.format("./convex peer start --address=%d --peer-key=%s", address.longValue(), shortAccountKey));
            output.writeToStream(this.cli().commandLine().getOut());
        }
        catch (ResultException | IOException | GeneralSecurityException t) {
            throw new CLIError("Error creating Peer", t);
        }
    }
}

