/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.cli.CLIError;
import convex.cli.mixins.AMixin;
import convex.net.IPUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

public class RemotePeerMixin
extends AMixin {
    @CommandLine.Option(names={"--port"}, defaultValue="${env:CONVEX_PORT:-18888}", description={"Port number to connect to remote peer. Defaulting to: ${DEFAULT-VALUE}"})
    private Integer port;
    @CommandLine.Option(names={"--host"}, defaultValue="${env:CONVEX_HOST}", description={"Hostname for remote peer connection. Can specify with CONVEX_HOST, or use \"none\" to disable."})
    private String hostname;

    public Convex connect() {
        InetSocketAddress sa = this.getSocketAddress();
        try {
            ConvexRemote c = Convex.connect((InetSocketAddress)sa);
            return c;
        }
        catch (ConnectException ce) {
            throw new CLIError("Cannot connect to host: " + String.valueOf(sa), ce);
        }
        catch (TimeoutException e) {
            throw new CLIError("Timeout while attempting to connect to peer: " + this.hostname, e);
        }
        catch (IOException e) {
            throw new CLIError("IO Error: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CLIError("Connection interrupted", e);
        }
    }

    public InetSocketAddress getSocketAddress() {
        int port = this.port != null ? this.port : 18888;
        String hostname = this.hostname != null ? this.hostname : "localhost";
        InetSocketAddress sa = IPUtils.parseAddress((String)hostname, (Integer)port);
        return sa;
    }

    public InetSocketAddress getSpecifiedSource() {
        if (this.hostname == null) {
            return null;
        }
        if (this.hostname.trim().equalsIgnoreCase("none")) {
            return null;
        }
        return this.getSocketAddress();
    }
}

