/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.mixins;

import convex.cli.CLIError;
import convex.cli.mixins.AMixin;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class KeyStoreMixin
extends AMixin {
    @CommandLine.Option(names={"--keystore"}, defaultValue="${env:CONVEX_KEYSTORE:-~/.convex/keystore.pfx}", scope=CommandLine.ScopeType.INHERIT, description={"Keystore filename. Can specify with CONVEX_KEYSTORE. Default: ${DEFAULT-VALUE}"})
    private String keyStoreFilename;
    @CommandLine.Option(names={"--storepass"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="${env:CONVEX_KEYSTORE_PASSWORD}", arity="0..1", description={"Store integrity password for the keystore."})
    char[] keystorePassword;
    KeyStore keyStore = null;
    static Logger log = LoggerFactory.getLogger(KeyStoreMixin.class);

    private File getKeyStoreFile() {
        if (this.keyStoreFilename != null) {
            File f = FileUtils.getFile((String)this.keyStoreFilename);
            return f;
        }
        return null;
    }

    public Path getStorePath() {
        return this.getKeyStoreFile().toPath();
    }

    public char[] getStorePassword() {
        if (this.keystorePassword != null) {
            return this.keystorePassword;
        }
        if (this.isParanoid()) {
            if (this.isInteractive()) {
                this.keystorePassword = this.readPassword("Enter keystore integrity password: ");
            } else {
                this.paranoia("Keystore integrity password must be explicitly provided");
            }
        }
        return this.keystorePassword;
    }

    public KeyStore getKeystore() {
        return this.keyStore;
    }

    public KeyStore ensureKeyStore() {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        return this.loadKeyStore(true, this.getStorePassword());
    }

    public KeyStore loadKeyStore() {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        return this.loadKeyStore(false, this.getStorePassword());
    }

    private KeyStore loadKeyStore(boolean shouldCreate, char[] password) {
        File keyFile = this.getKeyStoreFile();
        try {
            if (keyFile.exists()) {
                this.inform(3, "Loading key store at: " + String.valueOf(keyFile));
                this.keyStore = PFXTools.loadStore((File)keyFile, (char[])password);
            } else if (shouldCreate) {
                this.informWarning("No keystore exists, creating at: " + keyFile.getCanonicalPath());
                FileUtils.ensureFilePath((File)keyFile);
                this.keyStore = PFXTools.createStore((File)keyFile, (char[])password);
            } else {
                this.keyStore = null;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new CLIError("Unexpected security error: " + String.valueOf(e.getClass()), e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new CLIError(77, "Integrity password check failed for keystore: " + String.valueOf(keyFile), e.getCause());
            }
            throw new CLIError("Unable to load keystore due to unexpected IO Error: " + String.valueOf(keyFile), e);
        }
        return this.keyStore;
    }

    public void saveKeyStore() {
        this.saveKeyStore(this.keystorePassword);
    }

    public void saveKeyStore(char[] storePassword) {
        if (this.keyStore == null) {
            throw new CLIError("Trying to save a keystore that has not been loaded!");
        }
        try {
            if (this.keystorePassword == null) {
                this.paranoia("Trying to save keystore in strict mode with no integrity password");
            }
            PFXTools.saveStore((KeyStore)this.keyStore, (File)this.getKeyStoreFile(), (char[])storePassword);
        }
        catch (IOException | GeneralSecurityException t) {
            throw new CLIError("Failed to save keystore", t);
        }
    }

    public void addKeyPairToStore(AKeyPair keyPair, char[] keyPassword) {
        KeyStore keyStore = this.getKeystore();
        if (keyStore == null) {
            throw new CLIError("Trying to add key pair but keystore is not yet loaded!");
        }
        try {
            PFXTools.setKeyPair((KeyStore)keyStore, (AKeyPair)keyPair, (char[])keyPassword);
        }
        catch (IOException | GeneralSecurityException t) {
            throw new CLIError("Cannot store the key to the key store", t);
        }
    }

    public static String trimKey(String publicKey) {
        publicKey = publicKey.trim();
        if ((publicKey = publicKey.toLowerCase().replaceFirst("^0x", "").strip()).isEmpty()) {
            return null;
        }
        return publicKey;
    }

    public AKeyPair loadKeyFromStore(String publicKey, Supplier<char[]> passFunction) {
        if (publicKey == null) {
            return null;
        }
        if ((publicKey = KeyStoreMixin.trimKey(publicKey)) == null) {
            return null;
        }
        try {
            KeyStore keyStore = this.ensureKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (alias.indexOf(publicKey) != 0) continue;
                log.trace("found keypair " + alias);
                char[] keyPassword = passFunction.get();
                return PFXTools.getKeyPair((KeyStore)keyStore, (String)alias, (char[])keyPassword);
            }
            return null;
        }
        catch (UnrecoverableKeyException t) {
            throw new CLIError(78, "Cannot load key from key Store - possibly incorrect password?", t);
        }
        catch (GeneralSecurityException t) {
            throw new CLIError("Cannot load key from key Store", t);
        }
    }

    public boolean hasSingleKey(String pk) {
        return this.keyCount(pk) == 1;
    }

    public int keyCount(String pk) {
        pk = KeyStoreMixin.trimKey(pk);
        int result = 0;
        try {
            KeyStore keyStore = this.ensureKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (alias.indexOf(pk) != 0) continue;
                ++result;
            }
        }
        catch (GeneralSecurityException t) {
            throw new CLIError("Cannot load aliases from key Store", t);
        }
        return result;
    }
}

