/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.etch;

import convex.cli.CLIError;
import convex.cli.etch.AEtchCommand;
import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.lang.RT;
import convex.etch.EtchStore;
import picocli.CommandLine;

@CommandLine.Command(name="read", mixinStandardHelpOptions=true, description={"Reads data values from the Etch store."})
public class EtchRead
extends AEtchCommand {
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the retreived data. Defaults to STDOUT."})
    private String outputFilename;
    @CommandLine.Option(names={"--limit"}, description={"Print length limit for each value. Default is unlimited."})
    private Long printLimit;
    @CommandLine.Parameters(index="0", arity="0..*", description={"Hash(es) of data values to read."})
    private String[] hash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.outputFilename != null) {
            this.cli().setOut(this.outputFilename);
        }
        if (this.hash == null || this.hash.length == 0) {
            this.inform("No hash(es) provided to read. Suggestion: list one or more hashes at end of the command.");
            return;
        }
        try (EtchStore store = this.store();){
            for (String hs : this.hash) {
                Hash h = Hash.parse((String)hs);
                if (h == null) {
                    throw new CLIError(65, "Parameter [" + hs + "] not valid - should be 32-byte hash value");
                }
                Ref r = store.refForHash(h);
                if (r == null) {
                    this.inform("Hash not found [" + hs + "]");
                    this.println("");
                    continue;
                }
                long limit = this.printLimit == null ? Long.MAX_VALUE : this.printLimit;
                String s = RT.toString((ACell)r.getValue(), (long)limit);
                this.println(s);
            }
        }
    }
}

