/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.etch;

import convex.cli.CLIError;
import convex.cli.Main;
import convex.cli.etch.AEtchCommand;
import convex.core.data.ACell;
import convex.core.data.type.AType;
import convex.core.lang.RT;
import convex.etch.EtchStore;
import convex.etch.EtchUtils;
import convex.etch.IEtchIndexVisitor;
import java.io.IOException;
import picocli.CommandLine;

@CommandLine.Command(name="dump", mixinStandardHelpOptions=true, description={"Dumps Etch data to an exported format. Defaults to CSV with value ID, Type, Memory Size and encoding"})
public class EtchDump
extends AEtchCommand {
    @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file for the the Etch data dump."})
    private String outputFilename;

    @Override
    public void execute() {
        this.cli().setOut(this.outputFilename);
        try (EtchStore store = this.store();){
            store.getEtch().visitIndex((IEtchIndexVisitor)new DumpVisitor(this.cli()));
        }
        catch (IOException e) {
            throw new CLIError("IO Error traversing Etch store", e);
        }
    }

    public class DumpVisitor
    extends EtchUtils.EtchCellVisitor {
        protected Main cli;

        public DumpVisitor(Main cli) {
            this.cli = cli;
        }

        public void visitCell(ACell cell) {
            String hash = cell.getHash().toHexString();
            String encoding = cell.getEncoding().toHexString();
            AType type = RT.getType((ACell)cell);
            long mem = ACell.getMemorySize((ACell)cell);
            EtchDump.this.cli().println(hash + "," + String.valueOf(type) + "," + mem + "," + encoding);
        }
    }
}

