/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.CLIError;
import convex.cli.mixins.RemotePeerMixin;
import convex.cli.peer.APeerCommand;
import convex.cli.peer.Peer;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.State;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.init.Init;
import convex.core.store.AStore;
import convex.etch.EtchStore;
import convex.peer.API;
import convex.peer.ConfigException;
import convex.peer.LaunchException;
import convex.peer.Server;
import convex.restapi.RESTServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", mixinStandardHelpOptions=true, description={"Start a local peer."})
public class PeerStart
extends APeerCommand {
    private static final Logger log = LoggerFactory.getLogger(PeerStart.class);
    @CommandLine.ParentCommand
    private Peer peerParent;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--reset"}, description={"Reset and delete the etch database if it exists. Default: ${DEFAULT-VALUE}"})
    private boolean isReset;
    @CommandLine.Option(names={"--peer-port"}, defaultValue="18888", description={"Port number for the peer. Default is ${DEFAULT-VALUE}. If set to 0, will choose a random port."})
    private int port = 0;
    @CommandLine.Option(names={"--url"}, description={"URL for the peer to set for other peers to use."})
    private String url;
    @CommandLine.Option(names={"--base-url"}, description={"Base URL for REST API / web access."})
    private String baseURL;
    @CommandLine.Option(names={"--norest"}, description={"Disable REST srever."})
    private boolean norest;
    @CommandLine.Option(names={"--recalc"}, description={"Recalculate state from the specified block position onwards."})
    private Integer recalc;
    @CommandLine.Option(names={"--genesis"}, defaultValue="${env:CONVEX_GENESIS_SEED}", description={"Governance seed for network genesis. For testing use only."})
    private String genesis;
    @CommandLine.Option(names={"--api-port"}, defaultValue="8080", description={"Port for REST API."})
    private Integer apiport;
    @CommandLine.Mixin
    protected RemotePeerMixin peerMixin;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use for the peer controller."})
    private String controllerAddress;

    private AKeyPair findPeerKey(EtchStore store) {
        AKeyPair kp = this.specifiedPeerKey();
        if (kp != null) {
            return kp;
        }
        String specifiedKey = this.peerKeyMixin.getPublicKey();
        if (specifiedKey != null) {
            throw new CLIError(78, "Peer key not found in Store: " + specifiedKey);
        }
        this.paranoia("--peer-key not sepcified");
        log.debug("--peer-key not available, attempting to infer from store");
        try {
            ArrayList peerList = API.listPeers((AStore)store);
            if (peerList.size() == 0) {
                throw new CLIError(78, "No peers configured in Etch store " + String.valueOf(store) + ". Consider using `convex peer create` or `convex peer genesis` first.");
            }
            if (peerList.size() > 1) {
                throw new CLIError(78, "Multiple peers configured in Etch store " + String.valueOf(store) + ". specify which one you want with --peer-key.");
            }
            AccountKey peerKey = (AccountKey)peerList.get(0);
            AKeyPair pkp = this.storeMixin.loadKeyFromStore(peerKey.toHexString(), () -> this.peerKeyMixin.getKeyPassword());
            return pkp;
        }
        catch (IOException e) {
            log.debug("IO Exception trying to read etch peer list", (Throwable)e);
            return null;
        }
    }

    @Override
    public void execute() throws InterruptedException {
        Server server = null;
        this.storeMixin.ensureKeyStore();
        try (EtchStore store = this.etchMixin.getEtchStore();){
            AKeyPair peerKey;
            AKeyPair genesisKey = null;
            if (this.genesis != null && !this.genesis.isEmpty()) {
                this.paranoia("Should't use Genesis Seed in strict security mode! Consider key compromised!");
                Blob seed = Blob.parse((String)this.genesis);
                if (seed == null) {
                    throw new CLIError("Genesis seed must be 32 byte hex blob");
                }
                if (seed.count() != 32L) {
                    throw new CLIError("Genesis seed must be 32 byte hex blob");
                }
                genesisKey = peerKey = AKeyPair.create((Blob)seed);
                this.informWarning("Using test genesis seed: " + String.valueOf(seed));
            } else {
                peerKey = this.findPeerKey(store);
                if (peerKey == null) {
                    this.informWarning("No --peer-key specified or inferred from Etch Store " + String.valueOf(store));
                    this.showUsage();
                    return;
                }
            }
            Address controller = Address.parse((String)this.controllerAddress);
            if (controller == null) {
                this.paranoia("--address for peer controller not specified");
                log.debug("Controller address not specified.");
            }
            RESTServer restServer = null;
            try {
                InetSocketAddress remoteSource = this.peerMixin.getSpecifiedSource();
                HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
                config.put(Keywords.KEYPAIR, peerKey);
                config.put(Keywords.STORE, store);
                config.put(Keywords.URL, this.url);
                config.put(Keywords.PORT, this.port);
                if (remoteSource != null) {
                    config.put(Keywords.SOURCE, remoteSource);
                } else {
                    config.put(Keywords.RESTORE, true);
                }
                if (this.recalc != null) {
                    config.put(Keywords.RECALC, this.recalc);
                }
                config.put(Keywords.BASE_URL, this.baseURL);
                if (genesisKey != null) {
                    if (remoteSource != null) {
                        throw new CLIError("--genesis option should not be used when syncing with remote source");
                    }
                    AccountKey gpk = genesisKey.getAccountKey();
                    State state = Init.createState((AccountKey)gpk, (AccountKey)gpk, List.of(gpk));
                    this.informWarning("Created genesis State: " + String.valueOf(state.getHash()));
                    config.put(Keywords.STATE, state);
                }
                server = API.launchPeer(config);
                if (!this.norest) {
                    restServer = RESTServer.create((Server)server);
                    restServer.start(this.apiport);
                }
                this.informSuccess("Peer started");
                this.cli().notifyStartup();
                server.waitForShutdown();
                this.inform("Peer shutdown completed");
            }
            catch (ConfigException t) {
                throw new CLIError(78, "Error in peer configuration: " + t.getMessage(), t);
            }
            catch (LaunchException e) {
                throw new CLIError("Error launching peer: " + e.getMessage(), e);
            }
            finally {
                if (restServer != null) {
                    restServer.close();
                }
                if (server != null) {
                    server.close();
                }
            }
        }
    }
}

