/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.etch;

import convex.cli.etch.AEtchCommand;
import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.lang.Reader;
import convex.etch.EtchStore;
import picocli.CommandLine;

@CommandLine.Command(name="write", mixinStandardHelpOptions=true, description={"Writes data values to the Etch store."})
public class EtchWrite
extends AEtchCommand {
    @CommandLine.Option(names={"-c", "--cvx"}, description={"Convex data in readable format."})
    private String cvxData;

    @Override
    public void execute() {
        if (this.cvxData == null) {
            this.cli().inform("No data provided. Suggestion: use arg --cvx <data>");
            return;
        }
        try (EtchStore store = this.store();){
            ACell cell = Reader.read((String)this.cvxData);
            store.storeTopRef(Ref.get((ACell)cell), 3, null);
            Hash h = Ref.get((ACell)cell).getHash();
            this.println(h.toString());
            this.informSuccess("Data saved with hash: " + String.valueOf(h));
        }
    }
}

