/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.client;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.client.AClientCommand;
import convex.cli.output.RecordOutput;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.Keyword;
import convex.peer.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="status", mixinStandardHelpOptions=true, description={"Reports on the current status of the network."})
public class Status
extends AClientCommand {
    protected static final Logger log = LoggerFactory.getLogger(Status.class);

    @Override
    public void execute() {
        Convex convex = this.clientConnect();
        Result result = (Result)convex.requestStatus().join();
        AMap status = API.ensureStatusMap((ACell)result.getValue());
        if (status == null) {
            throw new CLIError(convex.toString() + " did not return a valid status, was : " + String.valueOf(result));
        }
        RecordOutput output = new RecordOutput();
        int n = API.STATUS_KEYS.size();
        for (int i = 0; i < n; ++i) {
            Keyword k = (Keyword)API.STATUS_KEYS.get(i);
            output.addField(k, status.get((ACell)k));
        }
        this.mainParent.printRecord(output);
    }
}

