/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ALongBlob;
import convex.core.data.Blob;
import convex.core.util.Utils;
import java.security.MessageDigest;

public final class LongBlob
extends ALongBlob {
    public static final int MAX_ENCODING_LENGTH = 10;
    public static final LongBlob ZERO = LongBlob.create(0L);

    private LongBlob(long value) {
        super(value);
    }

    public static LongBlob create(String string) {
        byte[] bs = Utils.hexToBytes(string);
        if (bs.length != 8) {
            throw new IllegalArgumentException("Long blob requires a length 8 hex string");
        }
        return new LongBlob(Utils.readLong(bs, 0));
    }

    public static LongBlob create(long value) {
        return new LongBlob(value);
    }

    @Override
    public void getBytes(byte[] dest, int destOffset) {
        Utils.writeLong(dest, destOffset, this.value);
    }

    @Override
    public ABlob slice(long start2, long end) {
        if (start2 == 0L && end == 8L) {
            return this;
        }
        if (start2 < 0L) {
            return null;
        }
        return this.getEncoding().slice(start2 + 2L, end + 2L);
    }

    @Override
    public Blob toFlatBlob() {
        if (this.encoding != null) {
            return this.encoding.slice(2L, 10L);
        }
        byte[] bs = new byte[8];
        Utils.writeLong(bs, 0, this.value);
        return Blob.wrap(bs);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        byte[] bs = this.getEncoding().getInternalArray();
        digest.update(bs, 2, 8);
    }

    @Override
    public long commonHexPrefixLength(ABlob b) {
        if (b == this) {
            return 16L;
        }
        long max = Math.min(8L, b.count());
        for (long i = 0L; i < max; ++i) {
            byte bi;
            byte ai = this.getUnchecked(i);
            if (ai == (bi = b.getUnchecked(i))) continue;
            return i * 2L + (long)(Utils.firstDigitMatch(ai, bi) ? 1 : 0);
        }
        return max * 2L;
    }

    @Override
    public boolean equals(ABlob a) {
        if (a instanceof LongBlob) {
            return ((LongBlob)a).value == this.value;
        }
        if (a instanceof Blob) {
            Blob b = (Blob)a;
            return b.count() == 8L && b.longValue() == this.value;
        }
        return false;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = 8;
        Utils.writeLong(bs, pos, this.value);
        return pos + 8;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public long hexMatchLength(ABlob b, long start2, long length) {
        if (b == this) {
            return length;
        }
        long end = start2 + length;
        for (long i = start2; i < end; ++i) {
            if (this.getHexDigit(i) == b.getHexDigit(i)) continue;
            return i - start2;
        }
        return length;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public boolean equalsBytes(byte[] bytes, int byteOffset) {
        return this.value == Utils.readLong(bytes, byteOffset);
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public Blob toCanonical() {
        return this.toFlatBlob();
    }
}

