/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.core.data.AccountKey;
import convex.core.util.Utils;
import java.net.InetSocketAddress;

public class SessionItem {
    protected static final String DELIMITER = ",";
    protected AccountKey accountKey;
    protected String hostname;
    protected String etchFilename;

    private SessionItem(AccountKey accountKey, String hostname, String etchFilename) {
        this.accountKey = accountKey;
        this.hostname = hostname;
        this.etchFilename = etchFilename;
    }

    public static SessionItem create(AccountKey accountKey, String hostname, String etchFilename) {
        return new SessionItem(accountKey, hostname, etchFilename);
    }

    public static SessionItem createFromString(String value) {
        String[] values2 = value.split(DELIMITER);
        return SessionItem.create(AccountKey.fromChecksumHex(values2[0]), values2[1], values2[2]);
    }

    public AccountKey getAccountKey() {
        return this.accountKey;
    }

    public String getName() {
        return this.accountKey.toChecksumHex();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        InetSocketAddress address = Utils.toInetSocketAddress(this.hostname);
        return address.getPort();
    }

    public InetSocketAddress getHostAddress() {
        return Utils.toInetSocketAddress(this.hostname);
    }

    public String getEtchFilename() {
        return this.etchFilename;
    }

    public String toString() {
        CharSequence[] values2 = new String[]{this.accountKey.toChecksumHex(), this.hostname, this.etchFilename};
        return String.join((CharSequence)DELIMITER, values2);
    }
}

